/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.MongoException;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.lang.Nullable;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

abstract class AbstractSubscription<TResult>
implements Subscription {
    private static final Logger LOGGER = Loggers.getLogger((String)"client");
    private final Subscriber<? super TResult> subscriber;
    private boolean requestedData;
    private boolean isProcessing;
    private long requested = 0L;
    private boolean isUnsubscribed = false;
    private boolean isTerminated = false;
    private final ConcurrentLinkedQueue<TResult> resultsQueue = new ConcurrentLinkedQueue();

    AbstractSubscription(Subscriber<? super TResult> subscriber) {
        this.subscriber = subscriber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe() {
        boolean unsubscribe = false;
        AbstractSubscription abstractSubscription = this;
        synchronized (abstractSubscription) {
            if (!this.isUnsubscribed) {
                unsubscribe = true;
                this.isUnsubscribed = true;
                this.isTerminated = true;
            }
        }
        if (unsubscribe) {
            this.postTerminate();
        }
    }

    public synchronized boolean isUnsubscribed() {
        return this.isUnsubscribed;
    }

    public void cancel() {
        this.unsubscribe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(long n) {
        if (!this.isUnsubscribed() && n < 1L) {
            this.onError(new IllegalArgumentException("3.9 While the Subscription is not cancelled, Subscription.request(long n) MUST throw a java.lang.IllegalArgumentException if the argument is <= 0."));
            return;
        }
        if (this.isTerminated()) {
            return;
        }
        boolean requestData = false;
        AbstractSubscription abstractSubscription = this;
        synchronized (abstractSubscription) {
            this.requested = this.requested + n < 1L ? Long.MAX_VALUE : (this.requested += n);
            if (!this.requestedData) {
                this.requestedData = true;
                requestData = true;
            }
        }
        if (requestData) {
            this.tryRequestInitialData();
        } else {
            this.tryProcessResultsQueue();
        }
    }

    abstract void requestInitialData();

    void requestMoreData() {
    }

    void postTerminate() {
    }

    abstract boolean checkCompleted();

    synchronized boolean isTerminated() {
        return this.isTerminated;
    }

    synchronized long getRequested() {
        return this.requested;
    }

    void addToQueue(@Nullable TResult result) {
        if (result != null) {
            this.resultsQueue.add(result);
        }
    }

    void addToQueue(@Nullable List<TResult> results) {
        if (results != null) {
            for (TResult cur : results) {
                this.addToQueue(cur);
            }
        }
    }

    void onError(Throwable t) {
        if (this.terminalAction()) {
            this.postTerminate();
            try {
                this.subscriber.onError(t);
            }
            catch (Throwable t1) {
                LOGGER.error("Calling onError threw an exception", t1);
                throw MongoException.fromThrowableNonNull((Throwable)t1);
            }
        } else {
            throw new MongoException("Subscription has already been terminated", t);
        }
    }

    private void onNext(TResult next) {
        if (!this.isTerminated()) {
            try {
                this.subscriber.onNext(next);
            }
            catch (Throwable t) {
                LOGGER.error("Calling onNext threw an exception", t);
                this.onError(t);
            }
        }
    }

    private void onComplete() {
        if (this.terminalAction()) {
            this.postTerminate();
            try {
                this.subscriber.onComplete();
            }
            catch (Throwable t) {
                LOGGER.error("Calling onComplete threw an exception", t);
                throw MongoException.fromThrowableNonNull((Throwable)t);
            }
        }
    }

    private void tryRequestInitialData() {
        try {
            this.requestInitialData();
        }
        catch (Throwable t) {
            this.onError(t);
        }
    }

    void tryProcessResultsQueue() {
        try {
            this.processResultsQueue();
        }
        catch (Throwable t) {
            this.onError(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResultsQueue() {
        boolean mustProcess = false;
        AbstractSubscription abstractSubscription = this;
        synchronized (abstractSubscription) {
            if (!this.isProcessing && !this.isTerminated) {
                this.isProcessing = true;
                mustProcess = true;
            }
        }
        if (mustProcess) {
            boolean requestMore = false;
            long processedCount = 0L;
            boolean completed = false;
            block6: while (true) {
                long localWanted;
                AbstractSubscription abstractSubscription2 = this;
                synchronized (abstractSubscription2) {
                    this.requested -= processedCount;
                    if (this.resultsQueue.isEmpty()) {
                        completed = this.checkCompleted();
                        requestMore = this.requested > 0L;
                        this.isProcessing = false;
                        break;
                    }
                    if (this.requested == 0L) {
                        this.isProcessing = false;
                        break;
                    }
                    localWanted = this.requested;
                }
                processedCount = 0L;
                while (true) {
                    TResult item;
                    if (localWanted <= 0L || (item = this.resultsQueue.poll()) == null) continue block6;
                    this.onNext(item);
                    --localWanted;
                    ++processedCount;
                }
                break;
            }
            if (completed) {
                this.onComplete();
            } else if (requestMore) {
                this.requestMoreData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean terminalAction() {
        boolean isTerminal = false;
        AbstractSubscription abstractSubscription = this;
        synchronized (abstractSubscription) {
            if (!this.isTerminated) {
                this.isTerminated = true;
                isTerminal = true;
            }
        }
        return isTerminal;
    }
}

