/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal.crypt;

import com.mongodb.MongoClientException;
import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.vault.DataKeyOptions;
import com.mongodb.client.model.vault.EncryptOptions;
import com.mongodb.client.model.vault.RewrapManyDataKeyOptions;
import com.mongodb.crypt.capi.MongoCryptException;
import com.mongodb.internal.capi.MongoCryptHelper;
import com.mongodb.internal.client.vault.EncryptOptionsHelper;
import com.mongodb.internal.crypt.capi.MongoCrypt;
import com.mongodb.internal.crypt.capi.MongoCryptContext;
import com.mongodb.internal.crypt.capi.MongoDataKeyOptions;
import com.mongodb.internal.crypt.capi.MongoKeyDecryptor;
import com.mongodb.internal.crypt.capi.MongoRewrapManyDataKeyOptions;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import com.mongodb.internal.time.Timeout;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.internal.crypt.CollectionInfoRetriever;
import com.mongodb.reactivestreams.client.internal.crypt.CommandMarker;
import com.mongodb.reactivestreams.client.internal.crypt.KeyManagementService;
import com.mongodb.reactivestreams.client.internal.crypt.KeyRetriever;
import java.io.Closeable;
import java.util.Map;
import java.util.function.Supplier;
import org.bson.BsonBinary;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.RawBsonDocument;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public class Crypt
implements Closeable {
    private static final RawBsonDocument EMPTY_RAW_BSON_DOCUMENT = RawBsonDocument.parse((String)"{}");
    private static final Logger LOGGER = Loggers.getLogger((String)"client");
    private final MongoCrypt mongoCrypt;
    private final Map<String, Map<String, Object>> kmsProviders;
    private final Map<String, Supplier<Map<String, Object>>> kmsProviderPropertySuppliers;
    private final CollectionInfoRetriever collectionInfoRetriever;
    private final CommandMarker commandMarker;
    private final KeyRetriever keyRetriever;
    private final KeyManagementService keyManagementService;
    private final boolean bypassAutoEncryption;
    @Nullable
    private final MongoClient collectionInfoRetrieverClient;
    @Nullable
    private final MongoClient keyVaultClient;

    Crypt(MongoCrypt mongoCrypt, KeyRetriever keyRetriever, KeyManagementService keyManagementService, Map<String, Map<String, Object>> kmsProviders, Map<String, Supplier<Map<String, Object>>> kmsProviderPropertySuppliers) {
        this(mongoCrypt, keyRetriever, keyManagementService, kmsProviders, kmsProviderPropertySuppliers, false, null, null, null, null);
    }

    Crypt(MongoCrypt mongoCrypt, KeyRetriever keyRetriever, KeyManagementService keyManagementService, Map<String, Map<String, Object>> kmsProviders, Map<String, Supplier<Map<String, Object>>> kmsProviderPropertySuppliers, boolean bypassAutoEncryption, @Nullable CollectionInfoRetriever collectionInfoRetriever, @Nullable CommandMarker commandMarker, @Nullable MongoClient collectionInfoRetrieverClient, @Nullable MongoClient keyVaultClient) {
        this.mongoCrypt = mongoCrypt;
        this.keyRetriever = keyRetriever;
        this.keyManagementService = keyManagementService;
        this.kmsProviders = kmsProviders;
        this.kmsProviderPropertySuppliers = kmsProviderPropertySuppliers;
        this.bypassAutoEncryption = bypassAutoEncryption;
        this.collectionInfoRetriever = collectionInfoRetriever;
        this.commandMarker = commandMarker;
        this.collectionInfoRetrieverClient = collectionInfoRetrieverClient;
        this.keyVaultClient = keyVaultClient;
    }

    public Mono<RawBsonDocument> encrypt(String databaseName, RawBsonDocument command, @Nullable Timeout operationTimeout) {
        Assertions.notNull((String)"databaseName", (Object)databaseName);
        Assertions.notNull((String)"command", (Object)command);
        if (this.bypassAutoEncryption) {
            return Mono.fromCallable(() -> command);
        }
        return this.executeStateMachine(() -> this.mongoCrypt.createEncryptionContext(databaseName, (BsonDocument)command), databaseName, operationTimeout);
    }

    public Mono<RawBsonDocument> decrypt(RawBsonDocument commandResponse, @Nullable Timeout operationTimeout) {
        Assertions.notNull((String)"commandResponse", (Object)commandResponse);
        return this.executeStateMachine(() -> this.mongoCrypt.createDecryptionContext((BsonDocument)commandResponse), operationTimeout).onErrorMap(this::wrapInClientException);
    }

    public Mono<RawBsonDocument> createDataKey(String kmsProvider, DataKeyOptions options, @Nullable Timeout operationTimeout) {
        Assertions.notNull((String)"kmsProvider", (Object)kmsProvider);
        Assertions.notNull((String)"options", (Object)options);
        return this.executeStateMachine(() -> this.mongoCrypt.createDataKeyContext(kmsProvider, MongoDataKeyOptions.builder().keyAltNames(options.getKeyAltNames()).masterKey(options.getMasterKey()).keyMaterial(options.getKeyMaterial()).build()), operationTimeout);
    }

    public Mono<BsonBinary> encryptExplicitly(BsonValue value, EncryptOptions options, @Nullable Timeout operationTimeout) {
        return this.executeStateMachine(() -> this.mongoCrypt.createExplicitEncryptionContext(new BsonDocument("v", value), EncryptOptionsHelper.asMongoExplicitEncryptOptions((EncryptOptions)options)), operationTimeout).map(result -> result.getBinary((Object)"v"));
    }

    public Mono<BsonDocument> encryptExpression(BsonDocument expression, EncryptOptions options, @Nullable Timeout operationTimeout) {
        return this.executeStateMachine(() -> this.mongoCrypt.createEncryptExpressionContext(new BsonDocument("v", (BsonValue)expression), EncryptOptionsHelper.asMongoExplicitEncryptOptions((EncryptOptions)options)), operationTimeout).map(result -> result.getDocument((Object)"v"));
    }

    public Mono<BsonValue> decryptExplicitly(BsonBinary value, @Nullable Timeout operationTimeout) {
        return this.executeStateMachine(() -> this.mongoCrypt.createExplicitDecryptionContext(new BsonDocument("v", (BsonValue)value)), operationTimeout).map(result -> result.get((Object)"v"));
    }

    public Mono<RawBsonDocument> rewrapManyDataKey(BsonDocument filter, RewrapManyDataKeyOptions options, @Nullable Timeout operationTimeout) {
        return this.executeStateMachine(() -> this.mongoCrypt.createRewrapManyDatakeyContext(filter, MongoRewrapManyDataKeyOptions.builder().provider(options.getProvider()).masterKey(options.getMasterKey()).build()), operationTimeout);
    }

    @Override
    public void close() {
        try (MongoCrypt ignored = this.mongoCrypt;
             CommandMarker ignored1 = this.commandMarker;
             MongoClient ignored2 = this.collectionInfoRetrieverClient;
             MongoClient ignored3 = this.keyVaultClient;){
            KeyManagementService ignored4 = this.keyManagementService;
            if (ignored4 != null) {
                ignored4.close();
            }
        }
    }

    private Mono<RawBsonDocument> executeStateMachine(Supplier<MongoCryptContext> cryptContextSupplier, @Nullable Timeout operationTimeout) {
        return this.executeStateMachine(cryptContextSupplier, null, operationTimeout);
    }

    private Mono<RawBsonDocument> executeStateMachine(Supplier<MongoCryptContext> cryptContextSupplier, @Nullable String databaseName, @Nullable Timeout operationTimeout) {
        try {
            MongoCryptContext cryptContext = cryptContextSupplier.get();
            return Mono.create(sink -> this.executeStateMachineWithSink(cryptContext, databaseName, (MonoSink<RawBsonDocument>)sink, operationTimeout)).onErrorMap(this::wrapInClientException).doFinally(s -> cryptContext.close());
        }
        catch (MongoCryptException e) {
            return Mono.error((Throwable)this.wrapInClientException(e));
        }
    }

    private void executeStateMachineWithSink(MongoCryptContext cryptContext, @Nullable String databaseName, MonoSink<RawBsonDocument> sink, @Nullable Timeout operationTimeout) {
        MongoCryptContext.State state = cryptContext.getState();
        switch (state) {
            case NEED_MONGO_COLLINFO: {
                this.collInfo(cryptContext, databaseName, sink, operationTimeout);
                break;
            }
            case NEED_MONGO_MARKINGS: {
                this.mark(cryptContext, databaseName, sink, operationTimeout);
                break;
            }
            case NEED_KMS_CREDENTIALS: {
                this.fetchCredentials(cryptContext, databaseName, sink, operationTimeout);
                break;
            }
            case NEED_MONGO_KEYS: {
                this.fetchKeys(cryptContext, databaseName, sink, operationTimeout);
                break;
            }
            case NEED_KMS: {
                this.decryptKeys(cryptContext, databaseName, sink, operationTimeout);
                break;
            }
            case READY: {
                sink.success((Object)cryptContext.finish());
                break;
            }
            case DONE: {
                sink.success((Object)EMPTY_RAW_BSON_DOCUMENT);
                break;
            }
            default: {
                sink.error((Throwable)new MongoInternalException("Unsupported encryptor state + " + state));
            }
        }
    }

    private void fetchCredentials(MongoCryptContext cryptContext, @Nullable String databaseName, MonoSink<RawBsonDocument> sink, @Nullable Timeout operationTimeout) {
        try {
            cryptContext.provideKmsProviderCredentials(MongoCryptHelper.fetchCredentials(this.kmsProviders, this.kmsProviderPropertySuppliers));
            this.executeStateMachineWithSink(cryptContext, databaseName, sink, operationTimeout);
        }
        catch (Exception e) {
            sink.error((Throwable)e);
        }
    }

    private void collInfo(MongoCryptContext cryptContext, @Nullable String databaseName, MonoSink<RawBsonDocument> sink, @Nullable Timeout operationTimeout) {
        if (this.collectionInfoRetriever == null) {
            sink.error((Throwable)new IllegalStateException("Missing collection Info retriever"));
        } else if (databaseName == null) {
            sink.error((Throwable)new IllegalStateException("Missing database name"));
        } else {
            this.collectionInfoRetriever.filter(databaseName, (BsonDocument)cryptContext.getMongoOperation(), operationTimeout).contextWrite(sink.contextView()).doOnNext(result -> cryptContext.addMongoOperationResult(result)).doOnComplete(() -> {
                cryptContext.completeMongoOperation();
                this.executeStateMachineWithSink(cryptContext, databaseName, sink, operationTimeout);
            }).doOnError(t -> sink.error((Throwable)MongoException.fromThrowableNonNull((Throwable)t))).subscribe();
        }
    }

    private void mark(MongoCryptContext cryptContext, @Nullable String databaseName, MonoSink<RawBsonDocument> sink, @Nullable Timeout operationTimeout) {
        if (this.commandMarker == null) {
            sink.error(this.wrapInClientException((Throwable)new MongoInternalException("Missing command marker")));
        } else if (databaseName == null) {
            sink.error(this.wrapInClientException(new IllegalStateException("Missing database name")));
        } else {
            this.commandMarker.mark(databaseName, cryptContext.getMongoOperation(), operationTimeout).contextWrite(sink.contextView()).doOnSuccess(result -> {
                cryptContext.addMongoOperationResult((BsonDocument)result);
                cryptContext.completeMongoOperation();
                this.executeStateMachineWithSink(cryptContext, databaseName, sink, operationTimeout);
            }).doOnError(e -> sink.error(this.wrapInClientException((Throwable)e))).subscribe();
        }
    }

    private void fetchKeys(MongoCryptContext cryptContext, @Nullable String databaseName, MonoSink<RawBsonDocument> sink, @Nullable Timeout operationTimeout) {
        this.keyRetriever.find((BsonDocument)cryptContext.getMongoOperation(), operationTimeout).contextWrite(sink.contextView()).doOnSuccess(results -> {
            for (BsonDocument result : results) {
                cryptContext.addMongoOperationResult(result);
            }
            cryptContext.completeMongoOperation();
            this.executeStateMachineWithSink(cryptContext, databaseName, sink, operationTimeout);
        }).doOnError(t -> sink.error((Throwable)MongoException.fromThrowableNonNull((Throwable)t))).subscribe();
    }

    private void decryptKeys(MongoCryptContext cryptContext, @Nullable String databaseName, MonoSink<RawBsonDocument> sink, @Nullable Timeout operationTimeout) {
        MongoKeyDecryptor keyDecryptor = cryptContext.nextKeyDecryptor();
        if (keyDecryptor != null) {
            this.keyManagementService.decryptKey(keyDecryptor, operationTimeout).contextWrite(sink.contextView()).doOnSuccess(r -> this.decryptKeys(cryptContext, databaseName, sink, operationTimeout)).doOnError(e -> sink.error(this.wrapInClientException((Throwable)e))).subscribe();
        } else {
            Mono.fromRunnable(() -> ((MongoCryptContext)cryptContext).completeKeyDecryptors()).contextWrite(sink.contextView()).doOnSuccess(r -> this.executeStateMachineWithSink(cryptContext, databaseName, sink, operationTimeout)).doOnError(e -> sink.error(this.wrapInClientException((Throwable)e))).subscribe();
        }
    }

    private Throwable wrapInClientException(Throwable t) {
        if (t instanceof MongoClientException) {
            return t;
        }
        return new MongoClientException("Exception in encryption library: " + t.getMessage(), t);
    }
}

