/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia;

import com.mongodb.DBObject;
import java.util.Set;
import javax.validation.Configuration;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import org.mongodb.morphia.AbstractEntityInterceptor;
import org.mongodb.morphia.EntityInterceptor;
import org.mongodb.morphia.Morphia;
import org.mongodb.morphia.VerboseJSR303ConstraintViolationException;
import org.mongodb.morphia.mapping.Mapper;

public class ValidationExtension
extends AbstractEntityInterceptor {
    private ValidatorFactory validationFactory;

    public ValidationExtension(Morphia m) {
        Configuration configuration = Validation.byDefaultProvider().configure();
        this.validationFactory = configuration.buildValidatorFactory();
        m.getMapper().addInterceptor((EntityInterceptor)this);
    }

    public ValidatorFactory getValidatorFactory() {
        return this.validationFactory;
    }

    public void prePersist(Object ent, DBObject dbObj, Mapper mapper) {
        Set validate = this.validationFactory.getValidator().validate(ent, new Class[0]);
        if (!validate.isEmpty()) {
            throw new VerboseJSR303ConstraintViolationException(validate);
        }
    }
}

