/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd.ext;

import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLong;
import org.cometd.Client;
import org.cometd.Extension;
import org.cometd.Message;
import org.mortbay.cometd.ClientImpl;
import org.mortbay.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticsExtension
implements Extension {
    protected static AtomicLong COUNTER = new AtomicLong();
    protected String _statsRequestChannel = null;
    protected String[] _statsRequestKeys = new String[]{"chat"};
    protected String _statsRequestSentinel = "//stats";
    protected String _statsConfirmSentinel = "//stats-confirm";
    protected String _statsResultSentinel = "//stats-results";
    protected String _probeChannel = null;
    protected String _probeSentinel = "//stats-probe";
    protected String[] _probeKeys = null;
    protected String _probeReplyChannel = null;
    protected String[] _probeReplyKeys = null;
    protected String _probeReplySentinel = "//stats-reply";
    protected String _delim = "::--";
    protected Map<String, Statistic> _statistics = new HashMap<String, Statistic>();
    protected Timer _timer = new Timer(true);
    protected long _timeout = 10000L;

    public void setStatsRequestKeys(String[] keys) {
        this._statsRequestKeys = keys;
    }

    public String[] getStatsRequestKeys() {
        return this._statsRequestKeys;
    }

    public void setStatsRequestSentinel(String val) {
        this._statsRequestSentinel = val;
    }

    public String getStatsRequestSentinel() {
        return this._statsRequestSentinel;
    }

    public void setStatsRequestChannel(String channel) {
        this._statsRequestChannel = channel;
    }

    public void setStatsConfirmSentinel(String val) {
        this._statsConfirmSentinel = val;
    }

    public String getStatsConfirmSentinel() {
        return this._statsConfirmSentinel;
    }

    public void setStatsResultSentinel(String val) {
        this._statsResultSentinel = val;
    }

    public String getStatsResultSentinel() {
        return this._statsResultSentinel;
    }

    public void setProbeChannel(String channel) {
        this._probeChannel = channel;
    }

    public void setProbeSentinel(String val) {
        this._probeSentinel = val;
    }

    public String getProbeSentinel() {
        return this._probeSentinel;
    }

    public void setProbeKeys(String[] keys) {
        this._probeKeys = keys;
    }

    public String[] getProbeKeys() {
        return this._probeKeys;
    }

    public void setProbeReplyKeys(String[] keys) {
        this._probeReplyKeys = keys;
    }

    public String[] getProbeReplyKeys() {
        return this._probeReplyKeys;
    }

    public void setProbeReplySentinel(String val) {
        this._probeReplySentinel = val;
    }

    public String getProbeReplySentinel() {
        return this._probeReplySentinel;
    }

    public void setProbeReplyChannel(String channel) {
        this._probeReplyChannel = channel;
    }

    public void setTimeout(long timeout) {
        this._timeout = timeout;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public void setDelim(String delim) {
        this._delim = delim;
    }

    public String getDelim() {
        return this._delim;
    }

    public Message rcv(Client from, Message message) {
        String match;
        String marker;
        Map<String, Object> map = this.matchMessage(message, this._probeReplyChannel, this._probeReplyKeys);
        if (map != null && (marker = this.matchSentinel(map, this._probeReplyKeys[this._probeReplyKeys.length - 1], this._probeReplySentinel)) != null) {
            this.updateStatistic(from, message, marker);
            return null;
        }
        map = this.matchMessage(message, this._statsRequestChannel, this._statsRequestKeys);
        if (map != null && (match = this.matchSentinel(map, this._statsRequestKeys[this._statsRequestKeys.length - 1], this._statsRequestSentinel)) != null && !match.startsWith(this._probeReplySentinel)) {
            Statistic stat = this.createStatistic(from, match);
            match = match + this._delim + stat._id + this._delim + System.currentTimeMillis();
            map.put(this._statsRequestKeys[this._statsRequestKeys.length - 1], match);
            this.onStatisticsRequest(message);
        }
        return message;
    }

    protected void onStatisticsRequest(Message message) {
    }

    public Message rcvMeta(Client from, Message message) {
        return message;
    }

    public Message send(Client from, Message message) {
        Statistic stat;
        String[] parts;
        String match;
        String[] keys = this._probeKeys == null ? this._statsRequestKeys : this._probeKeys;
        Map<String, Object> map = this.matchMessage(message, this._probeChannel, keys);
        if (map != null && (match = this.matchSentinel(map, keys[keys.length - 1], this._statsRequestSentinel)) != null && !match.startsWith(this._statsConfirmSentinel) && !match.startsWith(this._statsResultSentinel) && (parts = match.split(this._delim)) != null && parts.length > 1 && (stat = this._statistics.get(parts[1].trim())) != null) {
            stat.setProbe(message);
            stat.notifyStart();
            match = match.substring(this._statsRequestSentinel.length());
            map.put(keys[keys.length - 1], this._probeSentinel + match + this._delim + System.currentTimeMillis());
        }
        return message;
    }

    public Message sendMeta(Client from, Message message) {
        return message;
    }

    public Map<String, Object> matchMessage(Message message, String channel, String[] keys) {
        if (keys == null || keys.length == 0) {
            return null;
        }
        if (channel != null && !message.getChannel().equals(channel)) {
            return null;
        }
        Object node = message.get((Object)"data");
        if (node == null) {
            return null;
        }
        if (!Map.class.isAssignableFrom(node.getClass())) {
            return null;
        }
        return this.matchKeys((Map)node, keys);
    }

    public Map<String, Object> matchKeys(Map<String, Object> map, String[] keys) {
        Object node = map;
        for (int i = 0; i < keys.length - 1 && node != null; node = node.get(keys[i]), ++i) {
            if (Map.class.isAssignableFrom(node.getClass())) continue;
            node = null;
            break;
        }
        if (node == null) {
            return null;
        }
        if (!Map.class.isAssignableFrom(node.getClass())) {
            return null;
        }
        return node;
    }

    public String matchSentinel(Map<String, Object> map, String key, String sentinel) {
        if (map == null || key == null || sentinel == null) {
            return null;
        }
        Object value = map.get(key);
        if (value == null) {
            return null;
        }
        if (!String.class.isAssignableFrom(value.getClass())) {
            return null;
        }
        String text = (String)value;
        if (!text.startsWith(sentinel)) {
            return null;
        }
        return text;
    }

    protected Statistic createStatistic(Client from, String marker) {
        long timeout = this._timeout;
        String tmp = marker == null ? "" : marker;
        int idx = tmp.indexOf(",");
        if (idx > 0) {
            tmp = tmp.substring(idx + 1);
            try {
                timeout = Long.parseLong(tmp.trim()) * 1000L;
            }
            catch (NumberFormatException e) {
                Log.ignore((Throwable)e);
            }
        }
        return this.newStatistic(from, timeout);
    }

    protected void updateStatistic(Client from, Message message, String marker) {
        String[] tokens = marker.split(this._delim);
        if (tokens == null || tokens.length < 4) {
            return;
        }
        Statistic stat = this._statistics.get(tokens[1].trim());
        if (stat == null) {
            return;
        }
        long reqTimestamp = Long.valueOf(tokens[2].trim());
        long sentTimestamp = Long.valueOf(tokens[3].trim());
        int lag = from instanceof ClientImpl ? ((ClientImpl)from).getLag() : 0;
        stat.sample(reqTimestamp, sentTimestamp, System.currentTimeMillis(), lag);
    }

    protected Statistic newStatistic(Client from, long timeout) {
        return new Statistic(from, timeout);
    }

    public class Statistic
    extends TimerTask {
        public long _id;
        public Client _client;
        public Message _probeMessage;
        public long _timeout = 0L;
        public long _samples = 0L;
        public long _minRoundTrip = Long.MAX_VALUE;
        public long _maxRoundTrip = 0L;
        public long _avgRoundTrip = 0L;
        public long _totalRoundTrip;
        public long _minApp = Long.MAX_VALUE;
        public long _maxApp = 0L;
        public long _avgApp = 0L;
        public long _totalApp = 0L;
        public long _minInfra = Long.MAX_VALUE;
        public long _maxInfra = 0L;
        public long _avgInfra = 0L;
        public long _totalInfra = 0L;
        public long _minCometd = Long.MAX_VALUE;
        public long _maxCometd = 0L;
        public long _avgCometd = 0L;
        public long _totalCometd = 0L;

        public Statistic(Client client, long timeout) {
            this._id = COUNTER.incrementAndGet();
            this._client = client;
            this._timeout = timeout;
            StatisticsExtension.this._statistics.put(String.valueOf(this._id), this);
            StatisticsExtension.this._timer.schedule((TimerTask)this, timeout);
        }

        public void setProbe(Message probe) {
            this._probeMessage = (Message)probe.clone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sample(long reqTime, long sentTime, long rcvTime, long lag) {
            Statistic statistic = this;
            synchronized (statistic) {
                ++this._samples;
                long roundTrip = rcvTime - reqTime;
                if (roundTrip < this._minRoundTrip) {
                    this._minRoundTrip = roundTrip;
                }
                if (roundTrip > this._maxRoundTrip) {
                    this._maxRoundTrip = roundTrip;
                }
                this._totalRoundTrip += roundTrip;
                this._avgRoundTrip = this._totalRoundTrip / this._samples;
                long appTime = sentTime - reqTime;
                if (appTime < this._minApp) {
                    this._minApp = appTime;
                }
                if (appTime > this._maxApp) {
                    this._maxApp = appTime;
                }
                this._totalApp += appTime;
                this._avgApp = this._totalApp / this._samples;
                long infraTime = rcvTime - sentTime;
                if (infraTime < this._minInfra) {
                    this._minInfra = infraTime;
                }
                if (infraTime > this._maxInfra) {
                    this._maxInfra = infraTime;
                }
                this._totalInfra += infraTime;
                this._avgInfra = this._totalInfra / this._samples;
                long cometdTime = infraTime - 2L * lag;
                if (cometdTime < this._minCometd) {
                    this._minCometd = cometdTime;
                }
                if (cometdTime > this._maxCometd) {
                    this._maxCometd = cometdTime;
                }
                this._totalCometd += cometdTime;
                this._avgCometd = this._totalCometd / this._samples;
            }
        }

        public String toString() {
            return "Id " + this._id + ": samples=" + this._samples + ", avgR=" + this._avgRoundTrip + ", minR=" + this._minRoundTrip + ", maxR=" + this._maxRoundTrip + ", avgI=" + this._avgInfra + ", minI=" + this._minInfra + ", maxI=" + this._maxInfra + ", avgA=" + this._avgApp + ", minA=" + this._minApp + ", maxA=" + this._maxApp + ", avgC=" + this._avgCometd + ", minC=" + this._minCometd + ", maxC=" + this._maxCometd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Statistic statistic = this;
                synchronized (statistic) {
                    StatisticsExtension.this._statistics.remove(String.valueOf(this._id));
                    this.notifyEnd(this._client, this);
                }
            }
            catch (Exception x) {
                Log.warn((String)"Unexpected exception", (Throwable)x);
            }
        }

        public void notifyStart() {
            HashMap<String, Object> msg = new HashMap<String, Object>();
            msg.putAll((Map)this._probeMessage.get((Object)"data"));
            Map<String, Object> map = StatisticsExtension.this.matchKeys(msg, StatisticsExtension.this._statsRequestKeys);
            map.put(StatisticsExtension.this._statsRequestKeys[StatisticsExtension.this._statsRequestKeys.length - 1], StatisticsExtension.this._statsConfirmSentinel + this.getStartText());
            this._client.deliver(this._client, this._probeMessage.getChannel(), msg, null);
        }

        public String getStartText() {
            return " Statistic id=" + this._id + " started. Results due in " + this._timeout / 1000L + "s.";
        }

        public void notifyEnd(Client client, Statistic stat) {
            HashMap<String, Object> msg = new HashMap<String, Object>();
            msg.putAll((Map)this._probeMessage.get((Object)"data"));
            Map<String, Object> map = StatisticsExtension.this.matchKeys(msg, StatisticsExtension.this._statsRequestKeys);
            msg.put(StatisticsExtension.this._statsRequestKeys[StatisticsExtension.this._statsRequestKeys.length - 1], StatisticsExtension.this._statsResultSentinel + " " + this.getEndText());
            this._client.deliver(this._client, this._probeMessage.getChannel(), msg, null);
        }

        public String getEndText() {
            return this.toString();
        }
    }
}

