/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.jackson.dataformat;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserMinimalBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.DupDetector;
import com.fasterxml.jackson.core.json.JsonReadContext;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedList;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.core.buffer.ArrayBufferInput;
import org.msgpack.core.buffer.InputStreamBufferInput;
import org.msgpack.core.buffer.MessageBufferInput;
import org.msgpack.value.NumberValue;
import org.msgpack.value.ValueType;
import org.msgpack.value.holder.ValueHolder;

public class MessagePackParser
extends ParserMinimalBase {
    private static final ThreadLocal<MessageUnpacker> messageUnpackerHolder = new ThreadLocal();
    private ObjectCodec codec;
    private JsonReadContext parsingContext;
    private final LinkedList<StackItem> stack = new LinkedList();
    private final ValueHolder valueHolder = new ValueHolder();
    private boolean isClosed;
    private long tokenPosition;
    private long currentPosition;
    private final IOContext ioContext;

    public MessagePackParser(IOContext iOContext, int n, InputStream inputStream) throws IOException {
        this(iOContext, n, (MessageBufferInput)new InputStreamBufferInput(inputStream));
    }

    public MessagePackParser(IOContext iOContext, int n, byte[] byArray) throws IOException {
        this(iOContext, n, (MessageBufferInput)new ArrayBufferInput(byArray));
    }

    private MessagePackParser(IOContext iOContext, int n, MessageBufferInput messageBufferInput) throws IOException {
        this.ioContext = iOContext;
        DupDetector dupDetector = JsonParser.Feature.STRICT_DUPLICATE_DETECTION.enabledIn(n) ? DupDetector.rootDetector((JsonParser)this) : null;
        this.parsingContext = JsonReadContext.createRootContext((DupDetector)dupDetector);
        MessageUnpacker messageUnpacker = messageUnpackerHolder.get();
        if (messageUnpacker == null) {
            messageUnpacker = new MessageUnpacker(messageBufferInput);
        } else {
            messageUnpacker.reset(messageBufferInput);
        }
        messageUnpackerHolder.set(messageUnpacker);
    }

    public ObjectCodec getCodec() {
        return this.codec;
    }

    public void setCodec(ObjectCodec objectCodec) {
        this.codec = objectCodec;
    }

    public Version version() {
        return null;
    }

    public JsonToken nextToken() throws IOException, JsonParseException {
        MessageUnpacker messageUnpacker = this.getMessageUnpacker();
        this.tokenPosition = messageUnpacker.getTotalReadBytes();
        JsonToken jsonToken = null;
        if ((this.parsingContext.inObject() || this.parsingContext.inArray()) && this.stack.getFirst().isEmpty()) {
            this.stack.pop();
            this._currToken = this.parsingContext.inObject() ? JsonToken.END_OBJECT : JsonToken.END_ARRAY;
            this.parsingContext = this.parsingContext.getParent();
            return this._currToken;
        }
        MessageFormat messageFormat = messageUnpacker.getNextFormat();
        ValueType valueType = messageFormat.getValueType();
        StackItem stackItem = null;
        switch (valueType) {
            case NIL: {
                messageUnpacker.unpackNil();
                jsonToken = JsonToken.VALUE_NULL;
                break;
            }
            case BOOLEAN: {
                boolean bl = messageUnpacker.unpackBoolean();
                jsonToken = bl ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
                break;
            }
            case INTEGER: {
                messageUnpacker.unpackValue(this.valueHolder);
                jsonToken = JsonToken.VALUE_NUMBER_INT;
                break;
            }
            case FLOAT: {
                messageUnpacker.unpackValue(this.valueHolder);
                jsonToken = JsonToken.VALUE_NUMBER_FLOAT;
                break;
            }
            case STRING: {
                messageUnpacker.unpackValue(this.valueHolder);
                if (this.parsingContext.inObject() && this._currToken != JsonToken.FIELD_NAME) {
                    this.parsingContext.setCurrentName(this.valueHolder.getRef().asRaw().toString());
                    jsonToken = JsonToken.FIELD_NAME;
                    break;
                }
                jsonToken = JsonToken.VALUE_STRING;
                break;
            }
            case BINARY: {
                messageUnpacker.unpackValue(this.valueHolder);
                jsonToken = JsonToken.VALUE_EMBEDDED_OBJECT;
                break;
            }
            case ARRAY: {
                stackItem = new StackItemForArray(messageUnpacker.unpackArrayHeader());
                break;
            }
            case MAP: {
                stackItem = new StackItemForObject(messageUnpacker.unpackMapHeader());
                break;
            }
            case EXTENDED: {
                throw new UnsupportedOperationException();
            }
            default: {
                throw new IllegalStateException("Shouldn't reach here");
            }
        }
        this.currentPosition = messageUnpacker.getTotalReadBytes();
        if (this.parsingContext.inObject() && jsonToken != JsonToken.FIELD_NAME || this.parsingContext.inArray()) {
            this.stack.getFirst().consume();
        }
        if (stackItem != null) {
            this.stack.push(stackItem);
            if (stackItem instanceof StackItemForArray) {
                jsonToken = JsonToken.START_ARRAY;
                this.parsingContext = this.parsingContext.createChildArrayContext(-1, -1);
            } else if (stackItem instanceof StackItemForObject) {
                jsonToken = JsonToken.START_OBJECT;
                this.parsingContext = this.parsingContext.createChildObjectContext(-1, -1);
            }
        }
        this._currToken = jsonToken;
        return jsonToken;
    }

    protected void _handleEOF() throws JsonParseException {
    }

    public String getText() throws IOException, JsonParseException {
        return this.valueHolder.getRef().toString();
    }

    public char[] getTextCharacters() throws IOException, JsonParseException {
        return this.getText().toCharArray();
    }

    public boolean hasTextCharacters() {
        return false;
    }

    public int getTextLength() throws IOException, JsonParseException {
        return this.getText().length();
    }

    public int getTextOffset() throws IOException, JsonParseException {
        return 0;
    }

    public byte[] getBinaryValue(Base64Variant base64Variant) throws IOException, JsonParseException {
        return this.valueHolder.getRef().asBinary().toByteArray();
    }

    public Number getNumberValue() throws IOException, JsonParseException {
        NumberValue numberValue = this.valueHolder.getRef().asNumber();
        if (numberValue.isValidInt()) {
            return numberValue.toInt();
        }
        if (numberValue.isValidLong()) {
            return numberValue.toLong();
        }
        return numberValue.toBigInteger();
    }

    public int getIntValue() throws IOException, JsonParseException {
        return this.valueHolder.getRef().asNumber().toInt();
    }

    public long getLongValue() throws IOException, JsonParseException {
        return this.valueHolder.getRef().asNumber().toLong();
    }

    public BigInteger getBigIntegerValue() throws IOException, JsonParseException {
        return this.valueHolder.getRef().asNumber().toBigInteger();
    }

    public float getFloatValue() throws IOException, JsonParseException {
        return this.valueHolder.getRef().asFloat().toFloat();
    }

    public double getDoubleValue() throws IOException, JsonParseException {
        return this.valueHolder.getRef().asFloat().toDouble();
    }

    public BigDecimal getDecimalValue() throws IOException {
        return null;
    }

    public Object getEmbeddedObject() throws IOException, JsonParseException {
        return this.valueHolder.getRef().asBinary().toByteArray();
    }

    public JsonParser.NumberType getNumberType() throws IOException, JsonParseException {
        NumberValue numberValue = this.valueHolder.getRef().asNumber();
        if (numberValue.isValidInt()) {
            return JsonParser.NumberType.INT;
        }
        if (numberValue.isValidLong()) {
            return JsonParser.NumberType.LONG;
        }
        return JsonParser.NumberType.BIG_INTEGER;
    }

    public void close() throws IOException {
        try {
            MessageUnpacker messageUnpacker = this.getMessageUnpacker();
            messageUnpacker.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.isClosed = true;
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public JsonStreamContext getParsingContext() {
        return this.parsingContext;
    }

    public JsonLocation getTokenLocation() {
        return new JsonLocation(this.ioContext.getSourceReference(), this.tokenPosition, -1L, -1, (int)this.tokenPosition);
    }

    public JsonLocation getCurrentLocation() {
        return new JsonLocation(this.ioContext.getSourceReference(), this.currentPosition, -1L, -1, (int)this.currentPosition);
    }

    public void overrideCurrentName(String string) {
        try {
            if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
                JsonReadContext jsonReadContext = this.parsingContext.getParent();
                jsonReadContext.setCurrentName(string);
            } else {
                this.parsingContext.setCurrentName(string);
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new IllegalStateException(jsonProcessingException);
        }
    }

    public String getCurrentName() throws IOException {
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            JsonReadContext jsonReadContext = this.parsingContext.getParent();
            return jsonReadContext.getCurrentName();
        }
        return this.parsingContext.getCurrentName();
    }

    private MessageUnpacker getMessageUnpacker() {
        MessageUnpacker messageUnpacker = messageUnpackerHolder.get();
        if (messageUnpacker == null) {
            throw new IllegalStateException("messageUnpacker is null");
        }
        return messageUnpacker;
    }

    private static class StackItemForArray
    extends StackItem {
        StackItemForArray(long l) {
            super(l);
        }
    }

    private static class StackItemForObject
    extends StackItem {
        StackItemForObject(long l) {
            super(l);
        }
    }

    private static abstract class StackItem {
        private long numOfElements;

        protected StackItem(long l) {
            this.numOfElements = l;
        }

        public void consume() {
            --this.numOfElements;
        }

        public boolean isEmpty() {
            return this.numOfElements == 0L;
        }
    }
}

