/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata.parser.json;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.json.JSONException;
import org.json.JSONObject;
import org.mule.common.metadata.parser.json.AbstractType;
import org.mule.common.metadata.parser.json.JSONObjectType;
import org.mule.common.metadata.parser.json.JSONType;
import org.mule.common.metadata.parser.json.SchemaEnv;
import org.mule.common.metadata.parser.json.SchemaException;

public class JSONResourceType
extends AbstractType {
    private String resource;
    private JSONType fileType;
    private SchemaEnv env;

    public JSONResourceType(SchemaEnv env, String resource) {
        this.env = env;
        this.resource = resource;
        this.fileType = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadType() {
        ClassLoader loader = this.getClass().getClassLoader();
        try {
            InputStreamReader reader = new InputStreamReader(loader.getResourceAsStream(this.resource), "UTF-8");
            try {
                this.loadType(reader);
            }
            finally {
                ((Reader)reader).close();
            }
        }
        catch (IOException e) {
            this.fileType = new JSONType.Empty();
            throw new IllegalArgumentException(this.resource, e);
        }
    }

    private void loadType(Reader reader) {
        StringBuilder builder = new StringBuilder();
        char[] buffer = new char[1024];
        int read = -1;
        try {
            while ((read = reader.read(buffer)) != -1) {
                builder.append(buffer, 0, read);
            }
            String jsonString = builder.toString();
            JSONObject obj = new JSONObject(jsonString);
            this.fileType = new JSONObjectType(this.env, obj);
        }
        catch (IOException e) {
            this.fileType = new JSONType.Empty();
            throw new IllegalArgumentException(this.resource, e);
        }
        catch (JSONException e) {
            this.fileType = new JSONType.Empty();
            throw new IllegalArgumentException(this.resource, e);
        }
        catch (SchemaException e) {
            this.fileType = new JSONType.Empty();
            throw new IllegalArgumentException(this.resource, e);
        }
    }

    @Override
    public boolean contains(Object obj) {
        if (this.fileType == null) {
            this.loadType();
        }
        return this.fileType.contains(obj);
    }

    @Override
    public String explain(Object obj) {
        if (this.fileType == null) {
            this.loadType();
        }
        return this.fileType.explain(obj);
    }

    @Override
    public boolean isJSONPrimitive() {
        return false;
    }

    @Override
    public boolean isJSONArray() {
        return false;
    }

    @Override
    public boolean isJSONObject() {
        return false;
    }

    @Override
    public boolean isJSONPointer() {
        return false;
    }
}

