/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.api;

import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.runtime.api.util.MultiMap;

public class HttpRequestAttributesBuilder {
    private static final MultiMap<String, String> EMPTY_MAP = new MultiMap().toImmutableMultiMap();
    private MultiMap<String, String> headers = EMPTY_MAP;
    private MultiMap<String, String> queryParams = EMPTY_MAP;
    private Map<String, String> uriParams = Collections.emptyMap();
    private String requestPath;
    private String listenerPath;
    private String relativePath;
    private String version;
    private String scheme;
    private String method;
    private String requestUri;
    private String queryString = "";
    private String localAddress;
    private String remoteAddress;
    private Certificate clientCertificate;

    public HttpRequestAttributesBuilder() {
    }

    public HttpRequestAttributesBuilder(HttpRequestAttributes requestAttributes) {
        this.headers = requestAttributes.getHeaders();
        this.queryParams = requestAttributes.getQueryParams();
        this.uriParams = requestAttributes.getUriParams();
        this.requestPath = requestAttributes.getRequestPath();
        this.listenerPath = requestAttributes.getListenerPath();
        this.relativePath = requestAttributes.getRelativePath();
        this.version = requestAttributes.getVersion();
        this.scheme = requestAttributes.getScheme();
        this.method = requestAttributes.getMethod();
        this.requestUri = requestAttributes.getRequestUri();
        this.queryString = requestAttributes.getQueryString();
        this.localAddress = requestAttributes.getLocalAddress();
        this.remoteAddress = requestAttributes.getRemoteAddress();
        this.clientCertificate = requestAttributes.getClientCertificate();
    }

    public HttpRequestAttributesBuilder headers(MultiMap<String, String> headers) {
        Objects.requireNonNull(headers, "HTTP headers cannot be null.");
        this.headers = headers;
        return this;
    }

    public HttpRequestAttributesBuilder queryParams(MultiMap<String, String> queryParams) {
        Objects.requireNonNull(queryParams, "Query params cannot be null.");
        this.queryParams = queryParams;
        return this;
    }

    public HttpRequestAttributesBuilder uriParams(Map<String, String> uriParams) {
        Objects.requireNonNull(uriParams, "URI params cannot be null.");
        this.uriParams = uriParams;
        return this;
    }

    public HttpRequestAttributesBuilder requestPath(String requestPath) {
        this.requestPath = requestPath;
        return this;
    }

    public HttpRequestAttributesBuilder listenerPath(String listenerPath) {
        this.listenerPath = listenerPath;
        return this;
    }

    public HttpRequestAttributesBuilder relativePath(String relativePath) {
        this.relativePath = relativePath;
        return this;
    }

    public HttpRequestAttributesBuilder version(String version) {
        this.version = version;
        return this;
    }

    public HttpRequestAttributesBuilder scheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public HttpRequestAttributesBuilder method(String method) {
        this.method = method;
        return this;
    }

    public HttpRequestAttributesBuilder requestUri(String requestUri) {
        this.requestUri = requestUri;
        return this;
    }

    public HttpRequestAttributesBuilder queryString(String queryString) {
        Objects.requireNonNull(queryString, "Query string cannot be null.");
        this.queryString = queryString;
        return this;
    }

    public HttpRequestAttributesBuilder localAddress(String localAddress) {
        this.localAddress = localAddress;
        return this;
    }

    public HttpRequestAttributesBuilder remoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
        return this;
    }

    public HttpRequestAttributesBuilder clientCertificate(Certificate clientCertificate) {
        this.clientCertificate = clientCertificate;
        return this;
    }

    public HttpRequestAttributes build() {
        Objects.requireNonNull(this.listenerPath, "Listener path cannot be null.");
        Objects.requireNonNull(this.relativePath, "Relative path cannot be null.");
        Objects.requireNonNull(this.version, "HTTP version cannot be null.");
        Objects.requireNonNull(this.scheme, "Scheme cannot be null.");
        Objects.requireNonNull(this.method, "HTTP method cannot be null.");
        Objects.requireNonNull(this.requestPath, "Request path cannot be null.");
        Objects.requireNonNull(this.requestUri, "Request URI cannot be null.");
        Objects.requireNonNull(this.localAddress, "Local address cannot be null.");
        Objects.requireNonNull(this.remoteAddress, "Remote address cannot be null.");
        return new HttpRequestAttributes(this.headers, this.listenerPath, this.relativePath, this.version, this.scheme, this.method, this.requestPath, this.requestUri, this.queryString, this.queryParams, this.uriParams, this.localAddress, this.remoteAddress, this.clientCertificate);
    }
}

