/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.api.listener;

import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.mule.extension.http.api.HttpListenerResponseAttributes;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.extension.http.internal.filter.BasicUnauthorisedException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.security.Credentials;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.api.security.SecurityProviderNotFoundException;
import org.mule.runtime.api.security.UnauthorisedException;
import org.mule.runtime.api.security.UnknownAuthenticationTypeException;
import org.mule.runtime.api.security.UnsupportedAuthenticationSchemeException;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.security.AuthenticationHandler;
import org.mule.runtime.http.api.HttpConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpBasicAuthenticationFilter {
    protected static final Logger logger = LoggerFactory.getLogger(HttpBasicAuthenticationFilter.class);
    @Parameter
    private String realm;
    @Parameter
    @Optional
    @NullSafe
    private List<String> securityProviders;
    @Parameter
    @Optional(defaultValue="#[attributes]")
    HttpRequestAttributes attributes;

    public void authenticate(AuthenticationHandler authenticationHandler) throws SecurityException, SecurityProviderNotFoundException, UnknownAuthenticationTypeException {
        String header = (String)this.attributes.getHeaders().get((Object)"Authorization".toLowerCase());
        if (logger.isDebugEnabled()) {
            logger.debug("Authorization header: " + header);
        }
        if (header != null && header.startsWith("Basic ")) {
            String base64Token = header.substring(6);
            String token = new String(Base64.decodeBase64((byte[])base64Token.getBytes()));
            String username = "";
            String password = "";
            int delim = token.indexOf(":");
            if (delim != -1) {
                username = token.substring(0, delim);
                password = token.substring(delim + 1);
            }
            Credentials credentials = authenticationHandler.createCredentialsBuilder().withUsername(username).withPassword(password.toCharArray()).build();
            try {
                authenticationHandler.setAuthentication(this.securityProviders, authenticationHandler.createAuthentication(credentials));
            }
            catch (UnauthorisedException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Authentication request for user: " + username + " failed: " + e.toString());
                }
                throw new BasicUnauthorisedException(CoreMessages.authFailedForUser((Object)username), e, this.createUnauthenticatedMessage());
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Authentication success.");
            }
        } else {
            if (header == null) {
                throw new BasicUnauthorisedException(null, "HTTP basic authentication", "HTTP listener", this.createUnauthenticatedMessage());
            }
            throw new UnsupportedAuthenticationSchemeException(I18nMessageFactory.createStaticMessage((String)("Http Basic filter doesn't know how to handle header " + header)), this.createUnauthenticatedMessage());
        }
    }

    private Message createUnauthenticatedMessage() {
        String realmHeader = "Basic realm=";
        if (this.realm != null) {
            realmHeader = realmHeader + "\"" + this.realm + "\"";
        }
        MultiMap headers = new MultiMap();
        headers.put((Object)"WWW-Authenticate", (Object)realmHeader);
        return Message.builder().nullValue().attributesValue((Object)new HttpListenerResponseAttributes(HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode(), HttpConstants.HttpStatus.UNAUTHORIZED.getReasonPhrase(), (MultiMap<String, String>)headers)).build();
    }
}

