/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.api.policy;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.extension.http.api.listener.builder.HttpListenerErrorResponseBuilder;
import org.mule.extension.http.api.listener.builder.HttpListenerResponseBuilder;
import org.mule.extension.http.api.listener.builder.HttpListenerSuccessResponseBuilder;
import org.mule.extension.http.api.policy.HttpPolicyResponseAttributes;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.policy.SourcePolicyParametersTransformer;

public class HttpListenerPolicyParametersTransformer
implements SourcePolicyParametersTransformer {
    public boolean supports(ComponentIdentifier componentIdentifier) {
        return componentIdentifier.equals(ComponentIdentifier.buildFromStringRepresentation((String)"http:listener"));
    }

    public Message fromSuccessResponseParametersToMessage(Map<String, Object> parameters) {
        HttpListenerResponseBuilder responseBuilder = (HttpListenerResponseBuilder)parameters.get(ResponseType.SUCCESS.getResponseBuilderParameterName());
        return this.responseParametersToMessage(responseBuilder, ResponseType.SUCCESS.getStatusCode());
    }

    public Message fromFailureResponseParametersToMessage(Map<String, Object> parameters) {
        HttpListenerResponseBuilder responseBuilder = (HttpListenerResponseBuilder)parameters.get(ResponseType.FAILURE.getResponseBuilderParameterName());
        return this.responseParametersToMessage(responseBuilder, ResponseType.FAILURE.getStatusCode());
    }

    private Message responseParametersToMessage(HttpListenerResponseBuilder responseBuilder, int defaultStatusCode) {
        MultiMap headers = new MultiMap(responseBuilder.getHeaders());
        int statusCode = responseBuilder.getStatusCode() == null ? defaultStatusCode : responseBuilder.getStatusCode();
        return Message.builder().payload(responseBuilder.getBody()).attributesValue((Object)new HttpResponseAttributes(statusCode, responseBuilder.getReasonPhrase(), (MultiMap<String, String>)headers)).build();
    }

    public Map<String, Object> fromMessageToSuccessResponseParameters(Message message) {
        return this.messageToResponseParameters(new HttpListenerSuccessResponseBuilder(), message, ResponseType.SUCCESS);
    }

    public Map<String, Object> fromMessageToErrorResponseParameters(Message message) {
        return this.messageToResponseParameters(new HttpListenerErrorResponseBuilder(), message, ResponseType.FAILURE);
    }

    private Map<String, Object> messageToResponseParameters(HttpListenerResponseBuilder httpListenerResponseBuilder, Message message, ResponseType responseType) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder().put((Object)responseType.getResponseBuilderParameterName(), (Object)httpListenerResponseBuilder);
        if (message.getAttributes().getValue() instanceof HttpResponseAttributes) {
            HttpResponseAttributes httpResponseAttributes = (HttpResponseAttributes)message.getAttributes().getValue();
            httpListenerResponseBuilder.setBody((TypedValue<Object>)message.getPayload());
            httpListenerResponseBuilder.setStatusCode(httpResponseAttributes.getStatusCode());
            httpListenerResponseBuilder.setHeaders(httpResponseAttributes.getHeaders());
            httpListenerResponseBuilder.setReasonPhrase(httpResponseAttributes.getReasonPhrase());
            return mapBuilder.build();
        }
        if (message.getAttributes().getValue() instanceof HttpPolicyResponseAttributes) {
            HttpPolicyResponseAttributes httpResponseAttributes = (HttpPolicyResponseAttributes)message.getAttributes().getValue();
            httpListenerResponseBuilder.setBody((TypedValue<Object>)message.getPayload());
            httpListenerResponseBuilder.setHeaders(httpResponseAttributes.getHeaders());
            httpListenerResponseBuilder.setStatusCode(httpResponseAttributes.getStatusCode() == null ? responseType.getStatusCode() : httpResponseAttributes.getStatusCode().intValue());
            httpListenerResponseBuilder.setReasonPhrase(httpResponseAttributes.getReasonPhrase());
            return mapBuilder.build();
        }
        httpListenerResponseBuilder.setBody((TypedValue<Object>)message.getPayload());
        httpListenerResponseBuilder.setStatusCode(httpListenerResponseBuilder.getStatusCode() == null ? responseType.getStatusCode() : httpListenerResponseBuilder.getStatusCode().intValue());
        return mapBuilder.build();
    }

    static enum ResponseType {
        SUCCESS(200, "response"),
        FAILURE(500, "errorResponse");

        private int statusCode;
        private String responseBuilderParameterName;

        private ResponseType(int statusCode, String responseBuilderParameterName) {
            this.statusCode = statusCode;
            this.responseBuilderParameterName = responseBuilderParameterName;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getResponseBuilderParameterName() {
            return this.responseBuilderParameterName;
        }
    }
}

