/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.api.request.builder;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.mule.extension.http.api.HttpMessageBuilder;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.runtime.parameter.CorrelationInfo;
import org.mule.runtime.extension.api.runtime.parameter.OutboundCorrelationStrategy;

public class HttpRequesterRequestBuilder
extends HttpMessageBuilder {
    @Parameter
    @Content(primary=true)
    private TypedValue<Object> body;
    @Parameter
    @Optional
    @Content
    protected MultiMap<String, String> headers = new MultiMap();
    @Parameter
    @Optional
    @Content
    @DisplayName(value="URI Parameters")
    private Map<String, String> uriParams = new HashMap<String, String>();
    @Parameter
    @Optional
    @Content
    @DisplayName(value="Query Parameters")
    private MultiMap<String, String> queryParams = new MultiMap();
    @Parameter
    @ConfigOverride
    private OutboundCorrelationStrategy sendCorrelationId = OutboundCorrelationStrategy.AUTO;
    @Parameter
    @Optional
    private String correlationId;
    private CorrelationInfo correlationInfo;

    @Override
    public TypedValue<Object> getBody() {
        return this.body;
    }

    @Override
    public void setBody(TypedValue<Object> body) {
        this.body = body;
    }

    @Override
    public MultiMap<String, String> getHeaders() {
        return this.headers.toImmutableMultiMap();
    }

    @Override
    public void setHeaders(MultiMap<String, String> headers) {
        this.headers = headers;
    }

    public String replaceUriParams(String path) {
        for (String uriParamName : this.uriParams.keySet()) {
            String uriParamValue = this.uriParams.get(uriParamName);
            if (uriParamValue == null) {
                throw new NullPointerException(String.format("Expression {%s} evaluated to null.", uriParamName));
            }
            path = path.replaceAll(String.format("\\{%s\\}", uriParamName), uriParamValue);
        }
        return path;
    }

    public MultiMap<String, String> getQueryParams() {
        return this.queryParams.toImmutableMultiMap();
    }

    public Map<String, String> getUriParams() {
        return Collections.unmodifiableMap(this.uriParams);
    }

    public void setQueryParams(MultiMap<String, String> queryParams) {
        this.queryParams = queryParams;
    }

    public void setUriParams(Map<String, String> uriParams) {
        this.uriParams = uriParams;
    }

    public CorrelationInfo getCorrelationInfo() {
        return this.correlationInfo;
    }

    public void setCorrelationInfo(CorrelationInfo correlationInfo) {
        this.correlationInfo = correlationInfo;
    }

    public OutboundCorrelationStrategy getSendCorrelationId() {
        return this.sendCorrelationId;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }
}

