/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.api.request.validator;

import java.io.InputStream;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.extension.http.api.error.HttpError;
import org.mule.extension.http.api.error.HttpErrorMessageGenerator;
import org.mule.extension.http.api.request.validator.ResponseValidator;
import org.mule.extension.http.api.request.validator.ResponseValidatorException;
import org.mule.extension.http.api.request.validator.ResponseValidatorTypedException;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;

public abstract class RangeStatusCodeValidator
implements ResponseValidator {
    @Parameter
    private String values;
    private Function<Integer, Boolean> belongsFunction = ClassUtils.memoize(value -> {
        String[] valueParts;
        for (String valuePart : valueParts = this.values.split(",")) {
            if (valuePart.contains("..")) {
                String[] limits = valuePart.split("\\.\\.");
                int lower = Integer.parseInt(limits[0].trim());
                int upper = Integer.parseInt(limits[1].trim());
                if (value < lower || value > upper) continue;
                return true;
            }
            int code = Integer.parseInt(valuePart.trim());
            if (code != value) continue;
            return true;
        }
        return false;
    }, new ConcurrentHashMap());
    private HttpErrorMessageGenerator errorMessageGenerator = new HttpErrorMessageGenerator();

    protected boolean belongs(int value) {
        return this.belongsFunction.apply(value);
    }

    public String getValues() {
        return this.values;
    }

    public void setValues(String values) {
        this.values = values;
    }

    protected void throwValidationException(Result<InputStream, HttpResponseAttributes> result, HttpRequest request, int status) {
        Optional<HttpError> error = HttpError.getErrorByCode(status);
        if (error.isPresent()) {
            throw new ResponseValidatorTypedException(this.errorMessageGenerator.createFrom(request, status), error.get(), result);
        }
        throw new ResponseValidatorException(this.errorMessageGenerator.createFrom(request, status), result);
    }
}

