/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.lang3.StringUtils;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.extension.http.api.error.HttpError;
import org.mule.extension.http.api.error.ResourceNotFoundException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class StaticResourceLoader {
    private static final String ANY_PATH = "/*";
    private static final String ROOT_PATH = "/";
    private static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private MimetypesFileTypeMap mimeTypes = new MimetypesFileTypeMap();
    @Parameter
    private String resourceBasePath;
    @Parameter
    @Optional(defaultValue="index.html")
    private String defaultFile;
    @Parameter
    @Optional(defaultValue="#[attributes]")
    private HttpRequestAttributes attributes;

    public Result load() throws ResourceNotFoundException {
        Result result;
        File file;
        String path = this.attributes.getRequestPath();
        String contextPath = this.attributes.getListenerPath();
        if (contextPath.equals(ANY_PATH)) {
            contextPath = ROOT_PATH;
        }
        if (contextPath.endsWith(ANY_PATH)) {
            contextPath = StringUtils.removeEnd((String)contextPath, (String)ANY_PATH);
        }
        if (!ROOT_PATH.equals(contextPath)) {
            path = path.substring(contextPath.length());
        }
        if ((file = new File(this.resourceBasePath + path)).isDirectory()) {
            if (!path.endsWith(ROOT_PATH)) {
                path = path + ROOT_PATH;
            }
            file = new File(this.resourceBasePath + path + this.defaultFile);
        }
        FileInputStream in = null;
        try {
            Result result2;
            in = new FileInputStream(file);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copyLarge((InputStream)in, (OutputStream)baos);
            byte[] buffer = baos.toByteArray();
            String mimeType = this.mimeTypes.getContentType(file);
            if (mimeType == null) {
                mimeType = DEFAULT_MIME_TYPE;
            }
            result = result2 = Result.builder().output((Object)buffer).mediaType(MediaType.parse((String)mimeType)).build();
        }
        catch (IOException e) {
            try {
                throw new ResourceNotFoundException(e, HttpError.NOT_FOUND, this.getExceptionMessage(path));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)in);
        return result;
    }

    private I18nMessage getExceptionMessage(String path) {
        return I18nMessageFactory.createStaticMessage((String)String.format("The file: %s was not found.", this.resourceBasePath + path));
    }
}

