/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.listener;

import java.io.IOException;
import javax.inject.Inject;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.runtime.http.api.server.ServerCreationException;

@Alias(value="listener")
public class HttpListenerProvider
implements CachedConnectionProvider<HttpServer>,
Lifecycle {
    @RefName
    private String configName;
    @ParameterGroup(name="Connection")
    private ConnectionParams connectionParams;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="TLS Configuration")
    @Placement(tab="TLS")
    private TlsContextFactory tlsContext;
    @Inject
    private HttpService httpService;
    private HttpServer server;

    public void initialise() throws InitialisationException {
        if (this.connectionParams.port == null) {
            this.connectionParams.port = this.connectionParams.protocol.getDefaultPort();
        }
        if (this.connectionParams.protocol.equals((Object)HttpConstants.Protocol.HTTP) && this.tlsContext != null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"TlsContext cannot be configured with protocol HTTP. If you defined a tls:context element in your listener-config then you must set protocol=\"HTTPS\""), (Initialisable)this);
        }
        if (this.connectionParams.protocol.equals((Object)HttpConstants.Protocol.HTTPS) && this.tlsContext == null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Configured protocol is HTTPS but there's no TlsContext configured for configuration '%s'.", (Object[])new Object[]{this.configName}), (Initialisable)this);
        }
        if (this.tlsContext != null && !this.tlsContext.isKeyStoreConfigured()) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"KeyStore must be configured for server side SSL in configuration '%s'.", (Object[])new Object[]{this.configName}), (Initialisable)this);
        }
        if (this.tlsContext != null) {
            LifecycleUtils.initialiseIfNeeded((Object)this.tlsContext);
        }
        this.verifyConnectionsParameters();
        HttpServerConfiguration serverConfiguration = new HttpServerConfiguration.Builder().setHost(this.connectionParams.getHost()).setPort(this.connectionParams.getPort().intValue()).setTlsContextFactory(this.tlsContext).setUsePersistentConnections(this.connectionParams.getUsePersistentConnections()).setConnectionIdleTimeout(this.connectionParams.getConnectionIdleTimeout().intValue()).setName(this.configName).build();
        try {
            this.server = this.httpService.getServerFactory().create(serverConfiguration);
        }
        catch (ServerCreationException e) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)this.buildFailureMessage("create", e)), (Throwable)e, (Initialisable)this);
        }
    }

    public void start() throws MuleException {
        try {
            this.server.start();
        }
        catch (IOException e) {
            throw new DefaultMuleException((Throwable)new ConnectionException(this.buildFailureMessage("start", e), (Throwable)e));
        }
    }

    private String buildFailureMessage(String action, Throwable e) {
        StringBuilder builder = new StringBuilder().append("Could not ").append(action).append(" HTTP server for '").append(this.configName).append("' on port ").append(this.connectionParams.port);
        if (e.getMessage() != null) {
            builder.append(": ").append(e.getMessage());
        }
        return builder.toString();
    }

    public void stop() throws MuleException {
        this.server.stop();
    }

    public void dispose() {
        this.server.dispose();
    }

    public HttpServer connect() throws ConnectionException {
        return this.server;
    }

    public void disconnect(HttpServer server) {
    }

    public ConnectionValidationResult validate(HttpServer server) {
        if (server.isStopped() || server.isStopping()) {
            ServerAddress serverAddress = server.getServerAddress();
            return ConnectionValidationResult.failure((String)String.format("Server on host %s and port %s is stopped.", serverAddress.getIp(), serverAddress.getPort()), (Exception)new ConnectionException("Server stopped."));
        }
        return ConnectionValidationResult.success();
    }

    public ConnectionParams getConnectionParams() {
        return this.connectionParams;
    }

    private void verifyConnectionsParameters() throws InitialisationException {
        if (!this.connectionParams.getUsePersistentConnections()) {
            this.connectionParams.connectionIdleTimeout = 0;
        }
    }

    public static final class ConnectionParams {
        @Parameter
        @Optional(defaultValue="HTTP")
        @Expression(value=ExpressionSupport.NOT_SUPPORTED)
        @Placement(order=1)
        private HttpConstants.Protocol protocol;
        @Parameter
        @Example(value="0.0.0.0")
        @Expression(value=ExpressionSupport.NOT_SUPPORTED)
        @Placement(order=2)
        private String host;
        @Parameter
        @Example(value="8081")
        @Expression(value=ExpressionSupport.NOT_SUPPORTED)
        @Placement(order=3)
        private Integer port;
        @Parameter
        @Optional(defaultValue="true")
        @Expression(value=ExpressionSupport.NOT_SUPPORTED)
        @Placement(tab="Advanced", order=1)
        private boolean usePersistentConnections;
        @Parameter
        @Optional(defaultValue="30000")
        @Expression(value=ExpressionSupport.NOT_SUPPORTED)
        @Placement(tab="Advanced", order=2)
        private Integer connectionIdleTimeout;

        public HttpConstants.Protocol getProtocol() {
            return this.protocol;
        }

        public String getHost() {
            return this.host;
        }

        public Integer getPort() {
            return this.port;
        }

        public boolean getUsePersistentConnections() {
            return this.usePersistentConnections;
        }

        public Integer getConnectionIdleTimeout() {
            return this.connectionIdleTimeout;
        }
    }
}

