/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.listener;

import org.mule.extension.http.api.listener.builder.HttpListenerResponseBuilder;
import org.mule.extension.http.api.streaming.HttpStreamingType;
import org.mule.extension.http.internal.listener.HttpResponseContext;
import org.mule.extension.http.internal.listener.HttpResponseFactory;
import org.mule.extension.http.internal.listener.intercepting.Interception;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.extension.api.runtime.source.SourceCompletionCallback;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;

public class HttpListenerResponseSender {
    private final HttpResponseFactory responseFactory;

    public HttpListenerResponseSender(HttpResponseFactory responseFactory) {
        this.responseFactory = responseFactory;
    }

    public HttpListenerResponseSender(TransformationService transformationService) {
        this.responseFactory = new HttpResponseFactory(HttpStreamingType.NEVER, transformationService);
    }

    public void sendResponse(HttpResponseContext context, HttpListenerResponseBuilder response, SourceCompletionCallback completionCallback) throws Exception {
        HttpResponse httpResponse = this.buildResponse(response, context.getInterception(), context.isSupportStreaming());
        HttpResponseReadyCallback responseCallback = context.getResponseCallback();
        responseCallback.responseReady(httpResponse, this.getResponseFailureCallback(responseCallback, completionCallback));
    }

    protected HttpResponse buildResponse(HttpListenerResponseBuilder listenerResponseBuilder, Interception interception, boolean supportStreaming) throws Exception {
        HttpResponseBuilder responseBuilder = HttpResponse.builder();
        return this.doBuildResponse(responseBuilder, listenerResponseBuilder, interception, supportStreaming);
    }

    protected HttpResponse doBuildResponse(HttpResponseBuilder responseBuilder, HttpListenerResponseBuilder listenerResponseBuilder, Interception interception, boolean supportsStreaming) throws Exception {
        return this.responseFactory.create(responseBuilder, interception, listenerResponseBuilder, supportsStreaming);
    }

    private ResponseStatusCallback getResponseFailureCallback(final HttpResponseReadyCallback responseReadyCallback, final SourceCompletionCallback completionCallback) {
        return new ResponseStatusCallback(){

            public void responseSendFailure(Throwable throwable) {
                try {
                    responseReadyCallback.responseReady(HttpListenerResponseSender.this.buildErrorResponse(), (ResponseStatusCallback)this);
                    completionCallback.success();
                }
                catch (Throwable t) {
                    completionCallback.error(t);
                }
            }

            public void responseSendSuccessfully() {
                completionCallback.success();
            }
        };
    }

    protected HttpResponse buildErrorResponse() {
        HttpResponseBuilder errorResponseBuilder = HttpResponse.builder();
        HttpResponse errorResponse = errorResponseBuilder.statusCode(Integer.valueOf(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode())).reasonPhrase(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase()).build();
        return errorResponse;
    }
}

