/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.listener;

import java.net.URI;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.extension.http.api.HttpRequestAttributesBuilder;
import org.mule.extension.http.internal.listener.ListenerPath;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.request.ClientConnection;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.utils.HttpEncoderDecoderUtils;

public class HttpRequestAttributesResolver {
    private HttpRequestContext requestContext;
    private ListenerPath listenerPath;

    public HttpRequestAttributesResolver setRequestContext(HttpRequestContext requestContext) {
        this.requestContext = requestContext;
        return this;
    }

    public HttpRequestAttributesResolver setListenerPath(ListenerPath listenerPath) {
        this.listenerPath = listenerPath;
        return this;
    }

    public HttpRequestAttributes resolve() {
        String path;
        String listenerPath = this.listenerPath.getResolvedPath();
        HttpRequest request = this.requestContext.getRequest();
        URI uri = request.getUri();
        String uriString = path = uri.getPath();
        String relativePath = this.listenerPath.getRelativePath(path);
        ClientConnection clientConnection = this.requestContext.getClientConnection();
        MultiMap headers = new MultiMap();
        for (String headerName : request.getHeaderNames()) {
            headers.put((Object)headerName, request.getHeaderValues(headerName));
        }
        String queryString = uri.getQuery();
        if (queryString != null) {
            uriString = uriString + "?" + queryString;
        } else {
            queryString = "";
        }
        return new HttpRequestAttributesBuilder().listenerPath(listenerPath).relativePath(relativePath).requestPath(path).requestUri(uriString).method(request.getMethod()).scheme(this.requestContext.getScheme()).version(request.getProtocol().asString()).headers((MultiMap<String, String>)headers).uriParams(HttpEncoderDecoderUtils.decodeUriParams((String)listenerPath, (String)path)).queryString(queryString).queryParams((MultiMap<String, String>)HttpEncoderDecoderUtils.decodeQueryString((String)queryString)).localAddress(this.requestContext.getServerConnection().getLocalHostAddress().toString()).remoteAddress(clientConnection.getRemoteHostAddress().toString()).clientCertificate(clientConnection.getClientCertificate()).build();
    }
}

