/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.listener;

import java.io.InputStream;
import java.nio.charset.Charset;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.extension.http.internal.listener.HttpRequestAttributesResolver;
import org.mule.extension.http.internal.listener.ListenerPath;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestToResult {
    private static final Logger logger = LoggerFactory.getLogger(HttpRequestToResult.class);

    public static Result<InputStream, HttpRequestAttributes> transform(HttpRequestContext requestContext, Charset encoding, ListenerPath listenerPath) {
        HttpRequest request = requestContext.getRequest();
        MediaType mediaType = HttpRequestToResult.getMediaType(request.getHeaderValueIgnoreCase("Content-Type"), encoding);
        HttpEntity entity = request.getEntity();
        InputStream payload = entity.getContent();
        HttpRequestAttributes attributes = new HttpRequestAttributesResolver().setRequestContext(requestContext).setListenerPath(listenerPath).resolve();
        Result.Builder resultBuilder = Result.builder();
        if (entity.getLength().isPresent()) {
            resultBuilder.length((Long)entity.getLength().get());
        }
        return resultBuilder.output((Object)payload).mediaType(mediaType).attributes((Object)attributes).build();
    }

    public static MediaType getMediaType(String contentTypeValue, Charset defaultCharset) {
        MediaType mediaType = MediaType.ANY;
        if (contentTypeValue != null) {
            try {
                mediaType = MediaType.parse((String)contentTypeValue);
            }
            catch (IllegalArgumentException e) {
                if (Boolean.parseBoolean(System.getProperty("mule.strictContentType"))) {
                    throw e;
                }
                logger.warn(String.format("%s when parsing Content-Type '%s': %s", e.getClass().getName(), contentTypeValue, e.getMessage()));
                logger.warn(String.format("Using default encoding: %s", Charset.defaultCharset().name()));
            }
        }
        if (!mediaType.getCharset().isPresent()) {
            return mediaType.withCharset(defaultCharset);
        }
        return mediaType;
    }
}

