/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.listener;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.mule.extension.http.api.listener.builder.HttpListenerResponseBuilder;
import org.mule.extension.http.api.streaming.HttpStreamingType;
import org.mule.extension.http.internal.listener.HttpResponseHeaderBuilder;
import org.mule.extension.http.internal.listener.intercepting.Interception;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponseFactory {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private HttpStreamingType responseStreaming = HttpStreamingType.AUTO;
    private TransformationService transformationService;

    public HttpResponseFactory(HttpStreamingType responseStreaming, TransformationService transformationService) {
        this.responseStreaming = responseStreaming;
        this.transformationService = transformationService;
    }

    public HttpResponse create(HttpResponseBuilder responseBuilder, Interception interception, HttpListenerResponseBuilder listenerResponseBuilder, boolean supportsTransferEncoding) throws IOException {
        String reasonPhrase;
        EmptyHttpEntity httpEntity;
        HttpResponseHeaderBuilder httpResponseHeaderBuilder = new HttpResponseHeaderBuilder();
        this.addInterceptingHeaders(interception, httpResponseHeaderBuilder);
        this.addUserHeaders(listenerResponseBuilder, supportsTransferEncoding, httpResponseHeaderBuilder);
        TypedValue<Object> body = listenerResponseBuilder.getBody();
        if (httpResponseHeaderBuilder.getContentType() == null && !MediaType.ANY.matches(body.getDataType().getMediaType())) {
            httpResponseHeaderBuilder.addHeader("Content-Type", body.getDataType().getMediaType().toRfcString());
        }
        String existingTransferEncoding = httpResponseHeaderBuilder.getTransferEncoding();
        String existingContentLength = httpResponseHeaderBuilder.getContentLength();
        boolean hasLength = body.getLength().isPresent();
        Object payload = body.getValue();
        if (payload == null) {
            this.setupContentLengthEncoding(httpResponseHeaderBuilder, 0L);
            httpEntity = new EmptyHttpEntity();
        } else if (payload instanceof CursorStreamProvider || payload instanceof InputStream) {
            Object object = payload = payload instanceof CursorStreamProvider ? ((CursorStreamProvider)payload).openCursor() : payload;
            httpEntity = this.responseStreaming == HttpStreamingType.ALWAYS ? this.guaranteeStreamingIfPossible(supportsTransferEncoding, httpResponseHeaderBuilder, payload) : (this.responseStreaming == HttpStreamingType.AUTO ? (existingContentLength != null ? this.consumePayload(httpResponseHeaderBuilder, body) : ("chunked".equals(existingTransferEncoding) || !hasLength ? this.guaranteeStreamingIfPossible(supportsTransferEncoding, httpResponseHeaderBuilder, payload) : this.avoidConsumingPayload(httpResponseHeaderBuilder, payload, (Long)body.getLength().get()))) : (hasLength ? this.avoidConsumingPayload(httpResponseHeaderBuilder, payload, (Long)body.getLength().get()) : this.consumePayload(httpResponseHeaderBuilder, body)));
        } else {
            ByteArrayHttpEntity byteArrayHttpEntity = new ByteArrayHttpEntity(this.getMessageAsBytes(body));
            this.resolveEncoding(httpResponseHeaderBuilder, existingTransferEncoding, existingContentLength, supportsTransferEncoding, byteArrayHttpEntity);
            httpEntity = byteArrayHttpEntity;
        }
        Integer statusCode = listenerResponseBuilder.getStatusCode();
        if (statusCode != null) {
            if (statusCode < 200) {
                this.logger.warn(String.format("Response status code '%s' cannot be sent as a final response since it's lower than 200.", statusCode));
                throw new IllegalArgumentException("Cannot send a status code lower than 200");
            }
            responseBuilder.statusCode(statusCode);
            if (statusCode.intValue() == HttpConstants.HttpStatus.NO_CONTENT.getStatusCode() || statusCode.intValue() == HttpConstants.HttpStatus.NOT_MODIFIED.getStatusCode()) {
                httpEntity = new EmptyHttpEntity();
                httpResponseHeaderBuilder.removeHeader("Transfer-Encoding");
            }
        }
        if ((reasonPhrase = this.resolveReasonPhrase(listenerResponseBuilder.getReasonPhrase(), statusCode)) != null) {
            responseBuilder.reasonPhrase(reasonPhrase);
        }
        Collection<String> headerNames = httpResponseHeaderBuilder.getHeaderNames();
        for (String headerName : headerNames) {
            Collection<String> values = httpResponseHeaderBuilder.getHeader(headerName);
            for (String value : values) {
                responseBuilder.addHeader(headerName, value);
            }
        }
        responseBuilder.entity((HttpEntity)httpEntity);
        return responseBuilder.build();
    }

    private void addInterceptingHeaders(Interception interception, HttpResponseHeaderBuilder httpResponseHeaderBuilder) {
        interception.getHeaders().entryList().forEach(entry -> httpResponseHeaderBuilder.addHeader((String)entry.getKey(), entry.getValue()));
    }

    private void addUserHeaders(HttpListenerResponseBuilder listenerResponseBuilder, boolean supportsTransferEncoding, HttpResponseHeaderBuilder httpResponseHeaderBuilder) {
        MultiMap<String, String> headers = listenerResponseBuilder.getHeaders();
        headers.entryList().forEach(entry -> {
            if ("Transfer-Encoding".equals(entry.getKey()) && !supportsTransferEncoding) {
                this.logger.debug("Client HTTP version is lower than 1.1 so the unsupported 'Transfer-Encoding' header has been removed and 'Content-Length' will be sent instead.");
            } else {
                httpResponseHeaderBuilder.addHeader((String)entry.getKey(), entry.getValue());
            }
        });
    }

    private byte[] getMessageAsBytes(TypedValue payload) {
        return (byte[])this.transformationService.transform(Message.builder().payload(payload).build(), DataType.BYTE_ARRAY).getPayload().getValue();
    }

    public String resolveReasonPhrase(String builderReasonPhrase, Integer statusCode) {
        String reasonPhrase = builderReasonPhrase;
        if (reasonPhrase == null && statusCode != null) {
            reasonPhrase = HttpConstants.HttpStatus.getReasonPhraseForStatusCode((int)statusCode);
        }
        return reasonPhrase;
    }

    private HttpEntity guaranteeStreamingIfPossible(boolean possible, HttpResponseHeaderBuilder headerBuilder, Object stream) {
        if (possible) {
            this.setupChunkedEncoding(headerBuilder);
        }
        return new InputStreamHttpEntity((InputStream)stream);
    }

    private HttpEntity avoidConsumingPayload(HttpResponseHeaderBuilder httpResponseHeaderBuilder, Object payload, Long length) {
        this.setupContentLengthEncoding(httpResponseHeaderBuilder, length);
        return new InputStreamHttpEntity((InputStream)payload, length);
    }

    private HttpEntity consumePayload(HttpResponseHeaderBuilder httpResponseHeaderBuilder, TypedValue stream) {
        ByteArrayHttpEntity byteArrayHttpEntity = new ByteArrayHttpEntity(this.getMessageAsBytes(stream));
        this.setupContentLengthEncoding(httpResponseHeaderBuilder, byteArrayHttpEntity.getBytes().length);
        return byteArrayHttpEntity;
    }

    private void resolveEncoding(HttpResponseHeaderBuilder httpResponseHeaderBuilder, String existingTransferEncoding, String existingContentLength, boolean supportsTransferEncoding, ByteArrayHttpEntity byteArrayHttpEntity) {
        if (this.responseStreaming == HttpStreamingType.ALWAYS || this.responseStreaming == HttpStreamingType.AUTO && existingContentLength == null && "chunked".equals(existingTransferEncoding)) {
            if (supportsTransferEncoding) {
                this.setupChunkedEncoding(httpResponseHeaderBuilder);
            }
        } else {
            this.setupContentLengthEncoding(httpResponseHeaderBuilder, byteArrayHttpEntity.getBytes().length);
        }
    }

    private void setupContentLengthEncoding(HttpResponseHeaderBuilder httpResponseHeaderBuilder, long contentLength) {
        if (httpResponseHeaderBuilder.getTransferEncoding() != null) {
            this.logger.debug("Content-Length encoding is being used so the 'Transfer-Encoding' header has been removed");
            httpResponseHeaderBuilder.removeHeader("Transfer-Encoding");
        }
        httpResponseHeaderBuilder.setContentLength(String.valueOf(contentLength));
    }

    private void setupChunkedEncoding(HttpResponseHeaderBuilder httpResponseHeaderBuilder) {
        String existingTransferEncoding;
        if (httpResponseHeaderBuilder.getContentLength() != null) {
            this.logger.debug("Chunked encoding is being used so the 'Content-Length' header has been removed");
            httpResponseHeaderBuilder.removeHeader("Content-Length");
        }
        if (!"chunked".equals(existingTransferEncoding = httpResponseHeaderBuilder.getTransferEncoding())) {
            httpResponseHeaderBuilder.addHeader("Transfer-Encoding", "chunked");
        }
    }
}

