/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.listener;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.CaseInsensitiveMapWrapper;

public class HttpResponseHeaderBuilder {
    private static final Set<String> uniqueHeadersNames = new HashSet<String>(Arrays.asList("Transfer-Encoding".toLowerCase(), "Content-Length".toLowerCase(), "Content-Type".toLowerCase(), "Access-Control-Allow-Origin".toLowerCase()));
    Multimap<String, String> headers = Multimaps.newMultimap((Map)new CaseInsensitiveMapWrapper(), Sets::newHashSet);

    public void addHeader(String headerName, Object headerValue) {
        if (headerValue instanceof Iterable) {
            this.failIfHeaderDoesNotSupportMultipleValues(headerName);
            Iterable values = (Iterable)headerValue;
            for (Object value : values) {
                this.addSimpleValue(headerName, value.toString());
            }
        } else if (headerValue instanceof String[]) {
            String[] values;
            this.failIfHeaderDoesNotSupportMultipleValues(headerName);
            for (String value : values = (String[])headerValue) {
                this.addSimpleValue(headerName, value);
            }
        } else {
            this.addSimpleValue(headerName, headerValue.toString());
        }
    }

    public Collection<String> removeHeader(String headerName) {
        return this.headers.removeAll((Object)headerName);
    }

    private void failIfHeaderDoesNotSupportMultipleValues(String headerName) {
        if (uniqueHeadersNames.contains(headerName.toLowerCase())) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Header " + headerName + " does not support multiple values")));
        }
    }

    private void addSimpleValue(String headerName, String headerValue) {
        if (this.headers.containsKey((Object)headerName)) {
            this.failIfHeaderDoesNotSupportMultipleValues(headerName);
        }
        this.headers.put((Object)headerName, (Object)headerValue);
    }

    public String getContentType() {
        return this.getSimpleValue("Content-Type");
    }

    public String getTransferEncoding() {
        return this.getSimpleValue("Transfer-Encoding");
    }

    public String getContentLength() {
        return this.getSimpleValue("Content-Length");
    }

    private String getSimpleValue(String header) {
        if (!this.headers.containsKey((Object)header)) {
            return null;
        }
        return (String)this.headers.get((Object)header).iterator().next();
    }

    public void addContentType(String multipartFormData) {
        this.addSimpleValue("Content-Type", multipartFormData);
    }

    public void setContentLength(String calculatedContentLength) {
        this.removeHeader("Content-Length");
        this.addSimpleValue("Content-Length", calculatedContentLength);
    }

    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public Collection<String> getHeader(String headerName) {
        return this.headers.get((Object)headerName);
    }
}

