/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.listener.intercepting.cors;

import java.util.Map;
import org.mule.extension.http.internal.listener.intercepting.Interception;
import org.mule.extension.http.internal.listener.intercepting.NoInterception;
import org.mule.extension.http.internal.listener.intercepting.RequestInterruptedException;
import org.mule.extension.http.internal.listener.intercepting.cors.AddHeadersInterception;
import org.mule.modules.cors.response.AddCorsHeaders;
import org.mule.modules.cors.response.BlockRequest;
import org.mule.modules.cors.response.CorsAction;
import org.mule.modules.cors.response.NoCorsHeaders;
import org.mule.modules.cors.response.PreflightAction;
import org.mule.modules.cors.response.visitor.CorsResponseVisitor;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.HttpConstants;

public class CorsInterceptionFactory
implements CorsResponseVisitor<Interception> {
    public Interception from(CorsAction action) {
        return (Interception)action.accept((CorsResponseVisitor)this);
    }

    public Interception visit(BlockRequest blockRequest) {
        throw new RequestInterruptedException(HttpConstants.HttpStatus.OK, (MultiMap<String, String>)new MultiMap());
    }

    public Interception visit(NoCorsHeaders noCorsHeaders) {
        return new NoInterception();
    }

    public Interception visit(AddCorsHeaders addCorsHeaders) {
        return new AddHeadersInterception(addCorsHeaders);
    }

    public Interception visit(PreflightAction preflightAction) {
        Map headers = preflightAction.headers();
        headers.put("Access-Control-Allow-Origin", preflightAction.origin());
        throw new RequestInterruptedException(HttpConstants.HttpStatus.OK, (MultiMap<String, String>)new MultiMap(headers));
    }
}

