/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.extension.http.api.error.HttpError;
import org.mule.extension.http.api.request.HttpSendBodyMode;
import org.mule.extension.http.api.request.authentication.HttpRequestAuthentication;
import org.mule.extension.http.api.request.builder.HttpRequesterRequestBuilder;
import org.mule.extension.http.api.streaming.HttpStreamingType;
import org.mule.extension.http.internal.request.HttpRequesterConfig;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRequestFactory.class);
    private static final List<String> DEFAULT_EMPTY_BODY_METHODS = Lists.newArrayList((Object[])new String[]{"GET", "HEAD", "OPTIONS"});
    private static final String BOTH_TRANSFER_HEADERS_SET_MESSAGE = "Cannot send both Transfer-Encoding and Content-Length headers. Transfer-Encoding will not be sent.";
    private static final String TRANSFER_ENCODING_NOT_ALLOWED_WHEN_NEVER_MESSAGE = "Transfer-Encoding header will not be sent, as the configured requestStreamingMode is NEVER.";
    private static final String INVALID_TRANSFER_ENCODING_HEADER_MESSAGE = "Transfer-Encoding header value was invalid and will not be sent.";
    private final String uri;
    private final String method;
    private final HttpRequesterConfig config;
    private final HttpStreamingType streamingMode;
    private final HttpSendBodyMode sendBodyMode;
    private final TransformationService transformationService;

    HttpRequestFactory(HttpRequesterConfig config, String uri, String method, HttpStreamingType streamingMode, HttpSendBodyMode sendBodyMode, TransformationService transformationService) {
        this.config = config;
        this.uri = uri;
        this.method = method;
        this.streamingMode = streamingMode;
        this.sendBodyMode = sendBodyMode;
        this.transformationService = transformationService;
    }

    public HttpRequest create(HttpRequesterRequestBuilder requestBuilder, HttpRequestAuthentication authentication) {
        HttpRequestBuilder builder = HttpRequest.builder();
        ((HttpRequestBuilder)builder.uri(this.uri).method(this.method).headers(requestBuilder.getHeaders())).queryParams(requestBuilder.getQueryParams());
        this.config.getDefaultHeaders().forEach(header -> {
            HttpRequestBuilder cfr_ignored_0 = (HttpRequestBuilder)builder.addHeader(header.getKey(), header.getValue());
        });
        this.config.getDefaultQueryParams().forEach(param -> builder.addQueryParam(param.getKey(), param.getValue()));
        MediaType mediaType = requestBuilder.getBody().getDataType().getMediaType();
        if (!builder.getHeaderValue("Content-Type").isPresent() && !MediaType.ANY.matches(mediaType)) {
            builder.addHeader("Content-Type", mediaType.toRfcString());
        }
        requestBuilder.getSendCorrelationId().getOutboundCorrelationId(requestBuilder.getCorrelationInfo(), requestBuilder.getCorrelationId()).ifPresent(correlationId -> {
            String xCorrelationId;
            if (builder.getHeaderValue("X-Correlation-ID").isPresent()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("X-Correlation-ID was specified both as explicit header and through the standard propagation of the mule correlation ID. The explicit header will prevail.");
                }
                xCorrelationId = (String)builder.getHeaderValue("X-Correlation-ID").get();
            } else {
                xCorrelationId = correlationId;
                builder.addHeader("X-Correlation-ID", correlationId);
            }
            builder.getHeaderValue("MULE_CORRELATION_ID").ifPresent(muleCorrelationId -> LOGGER.warn("Explicitly configured 'MULE_CORRELATION_ID: {}' header could interfere with 'X-Correlation-ID: {}' header.", muleCorrelationId, (Object)xCorrelationId));
        });
        if (this.config.isEnableCookies()) {
            try {
                Map<String, List<String>> headers = this.config.getCookieManager().get(builder.getUri(), Collections.emptyMap());
                List<String> cookies = headers.get("Cookie");
                if (cookies != null) {
                    for (String cookie : cookies) {
                        builder.addHeader("Cookie", cookie);
                    }
                }
            }
            catch (IOException e) {
                LOGGER.warn("Error reading cookies for URI " + this.uri, (Throwable)e);
            }
        }
        try {
            builder.entity(this.createRequestEntity(builder, this.method, requestBuilder.getBody()));
        }
        catch (Exception e) {
            throw new ModuleException((ErrorTypeDefinition)HttpError.TRANSFORMATION, (Throwable)e);
        }
        if (authentication != null) {
            try {
                authentication.authenticate(builder);
            }
            catch (MuleException e) {
                throw new ModuleException((ErrorTypeDefinition)HttpError.SECURITY, (Throwable)e);
            }
        }
        return builder.build();
    }

    private HttpEntity createRequestEntity(HttpRequestBuilder requestBuilder, String resolvedMethod, TypedValue<?> body) {
        Object entity;
        Object payload = body.getValue();
        Optional length = body.getLength();
        Optional transferEncoding = requestBuilder.getHeaderValue("Transfer-Encoding");
        Optional contentLength = requestBuilder.getHeaderValue("Content-Length");
        if (this.isEmptyBody(payload, resolvedMethod)) {
            entity = new EmptyHttpEntity();
        } else if (payload instanceof InputStream || payload instanceof CursorStreamProvider) {
            Object object = payload = payload instanceof CursorStreamProvider ? ((CursorStreamProvider)payload).openCursor() : payload;
            if (this.streamingMode == HttpStreamingType.ALWAYS) {
                entity = this.guaranteeStreaming(requestBuilder, transferEncoding, contentLength, (InputStream)payload);
            } else if (this.streamingMode == HttpStreamingType.AUTO) {
                if (contentLength.isPresent()) {
                    this.sanitizeForContentLength(requestBuilder, transferEncoding, BOTH_TRANSFER_HEADERS_SET_MESSAGE);
                    entity = new ByteArrayHttpEntity(this.getPayloadAsBytes(payload));
                } else if (transferEncoding.isPresent() && "chunked".equalsIgnoreCase((String)transferEncoding.get()) || !length.isPresent()) {
                    entity = new InputStreamHttpEntity((InputStream)payload);
                } else {
                    this.sanitizeForContentLength(requestBuilder, transferEncoding, INVALID_TRANSFER_ENCODING_HEADER_MESSAGE);
                    entity = this.avoidConsumingPayload(requestBuilder, (InputStream)payload, length);
                }
            } else {
                this.sanitizeForContentLength(requestBuilder, transferEncoding, TRANSFER_ENCODING_NOT_ALLOWED_WHEN_NEVER_MESSAGE);
                entity = length.isPresent() ? this.avoidConsumingPayload(requestBuilder, (InputStream)payload, length) : new ByteArrayHttpEntity(this.getPayloadAsBytes(payload));
            }
        } else {
            byte[] payloadAsBytes = this.getPayloadAsBytes(payload);
            if (this.streamingMode == HttpStreamingType.ALWAYS) {
                entity = this.guaranteeStreaming(requestBuilder, transferEncoding, contentLength, new ByteArrayInputStream(payloadAsBytes));
            } else if (this.streamingMode == HttpStreamingType.NEVER) {
                this.sanitizeForContentLength(requestBuilder, transferEncoding, TRANSFER_ENCODING_NOT_ALLOWED_WHEN_NEVER_MESSAGE);
                entity = new ByteArrayHttpEntity(payloadAsBytes);
            } else {
                if (contentLength.isPresent() && transferEncoding.isPresent()) {
                    this.sanitizeForContentLength(requestBuilder, transferEncoding, BOTH_TRANSFER_HEADERS_SET_MESSAGE);
                }
                entity = new InputStreamHttpEntity((InputStream)new ByteArrayInputStream(payloadAsBytes), Long.valueOf(payloadAsBytes.length));
            }
        }
        return entity;
    }

    private boolean isEmptyBody(Object body, String method) {
        boolean emptyBody;
        if (body == null) {
            emptyBody = true;
        } else {
            emptyBody = DEFAULT_EMPTY_BODY_METHODS.contains(method);
            if (this.sendBodyMode != HttpSendBodyMode.AUTO) {
                emptyBody = this.sendBodyMode == HttpSendBodyMode.NEVER;
            }
        }
        return emptyBody;
    }

    private HttpEntity guaranteeStreaming(HttpRequestBuilder requestBuilder, Optional<String> transferEncoding, Optional<String> contentLength, InputStream stream) {
        this.sanitizeForStreaming(requestBuilder, transferEncoding, contentLength);
        return new InputStreamHttpEntity(stream);
    }

    private HttpEntity avoidConsumingPayload(HttpRequestBuilder requestBuilder, InputStream payload, Optional<Long> length) {
        requestBuilder.addHeader("Content-Length", String.valueOf(length.get()));
        return new InputStreamHttpEntity(payload, length.get());
    }

    private byte[] getPayloadAsBytes(Object payload) {
        return (byte[])this.transformationService.transform(Message.of((Object)payload), DataType.BYTE_ARRAY).getPayload().getValue();
    }

    private void sanitizeForStreaming(HttpRequestBuilder requestBuilder, Optional<String> transferEncodingHeader, Optional<String> contentLengthHeader) {
        if (contentLengthHeader != null) {
            requestBuilder.removeHeader("Content-Length");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Content-Length header will not be sent, as the configured requestStreamingMode is ALWAYS.");
            }
        }
        if (transferEncodingHeader.isPresent() && !transferEncodingHeader.get().equalsIgnoreCase("chunked")) {
            requestBuilder.removeHeader("Transfer-Encoding");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Transfer-Encoding header will be sent with value 'chunked' instead of {}, as the configured requestStreamingMode is ALWAYS", transferEncodingHeader);
            }
        }
    }

    private void sanitizeForContentLength(HttpRequestBuilder requestBuilder, Optional<String> transferEncoding, String reason) {
        if (transferEncoding.isPresent()) {
            requestBuilder.removeHeader("Transfer-Encoding");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(reason);
            }
        }
    }
}

