/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.extension.http.api.error.HttpError;
import org.mule.extension.http.api.error.HttpErrorMessageGenerator;
import org.mule.extension.http.api.error.HttpRequestFailedException;
import org.mule.extension.http.api.notification.HttpNotificationAction;
import org.mule.extension.http.api.notification.HttpRequestNotificationData;
import org.mule.extension.http.api.notification.HttpResponseNotificationData;
import org.mule.extension.http.api.request.HttpSendBodyMode;
import org.mule.extension.http.api.request.authentication.HttpRequestAuthentication;
import org.mule.extension.http.api.request.authentication.UsernamePasswordAuthentication;
import org.mule.extension.http.api.request.builder.HttpRequesterRequestBuilder;
import org.mule.extension.http.api.request.client.UriParameters;
import org.mule.extension.http.api.request.validator.ResponseValidator;
import org.mule.extension.http.api.streaming.HttpStreamingType;
import org.mule.extension.http.internal.HttpConnectorConstants;
import org.mule.extension.http.internal.request.HttpRequestFactory;
import org.mule.extension.http.internal.request.HttpRequesterConfig;
import org.mule.extension.http.internal.request.HttpResponseToResult;
import org.mule.extension.http.internal.request.client.HttpExtensionClient;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.notification.NotificationActionDefinition;
import org.mule.runtime.extension.api.notification.NotificationEmitter;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class HttpRequester {
    private static final Logger logger = LoggerFactory.getLogger(HttpRequester.class);
    private final boolean followRedirects;
    private final HttpRequestAuthentication authentication;
    private final int responseTimeout;
    private final ResponseValidator responseValidator;
    private final HttpRequesterConfig config;
    private final NotificationEmitter notificationEmitter;
    private final HttpRequestFactory eventToHttpRequest;
    private final Scheduler scheduler;
    private final int retryAttempts;
    private HttpErrorMessageGenerator errorMessageGenerator = new HttpErrorMessageGenerator();

    public HttpRequester(HttpRequestFactory eventToHttpRequest, boolean followRedirects, HttpRequestAuthentication authentication, int responseTimeout, ResponseValidator responseValidator, HttpRequesterConfig config, Scheduler scheduler, NotificationEmitter notificationEmitter) {
        this.followRedirects = followRedirects;
        this.authentication = authentication;
        this.responseTimeout = responseTimeout;
        this.responseValidator = responseValidator;
        this.config = config;
        this.scheduler = scheduler;
        this.eventToHttpRequest = eventToHttpRequest;
        this.notificationEmitter = notificationEmitter;
        this.retryAttempts = Integer.getInteger("mule.http.client.maxRetries", 3);
    }

    public void doRequest(HttpExtensionClient client, HttpRequesterRequestBuilder requestBuilder, boolean checkRetry, MuleContext muleContext, CompletionCallback<InputStream, HttpResponseAttributes> callback) {
        this.doRequestWithRetry(client, requestBuilder, checkRetry, muleContext, callback, this.eventToHttpRequest.create(requestBuilder, this.authentication), this.retryAttempts);
    }

    private void doRequestWithRetry(HttpExtensionClient client, HttpRequesterRequestBuilder requestBuilder, boolean checkRetry, MuleContext muleContext, CompletionCallback<InputStream, HttpResponseAttributes> callback, HttpRequest httpRequest, int retryCount) {
        this.notificationEmitter.fire((NotificationActionDefinition)HttpNotificationAction.REQUEST_START, TypedValue.of((Object)HttpRequestNotificationData.from(httpRequest)));
        client.send(httpRequest, this.responseTimeout, this.followRedirects, this.resolveAuthentication(this.authentication)).whenComplete((response, exception) -> {
            if (response != null) {
                this.notificationEmitter.fire((NotificationActionDefinition)HttpNotificationAction.REQUEST_COMPLETE, TypedValue.of((Object)HttpResponseNotificationData.from(response)));
                HttpResponseToResult httpResponseToResult = new HttpResponseToResult(this.config, muleContext);
                Mono.from(httpResponseToResult.convert((HttpResponse)response, httpRequest.getUri())).doOnNext(result -> {
                    try {
                        if (this.resendRequest((Result)result, checkRetry, this.authentication)) {
                            this.scheduler.submit(() -> this.consumePayload((Result)result));
                            this.doRequest(client, requestBuilder, false, muleContext, callback);
                        } else {
                            this.responseValidator.validate((Result<InputStream, HttpResponseAttributes>)result, httpRequest);
                            callback.success(result);
                        }
                    }
                    catch (Exception e) {
                        callback.error((Throwable)e);
                    }
                }).doOnError(Exception.class, e -> callback.error((Throwable)e)).subscribe();
            } else {
                this.checkIfRemotelyClosed((Throwable)exception, client.getDefaultUriParameters());
                if (this.shouldRetryRemotelyClosed((Throwable)exception, retryCount, httpRequest.getMethod())) {
                    this.doRequestWithRetry(client, requestBuilder, checkRetry, muleContext, callback, httpRequest, retryCount - 1);
                    return;
                }
                logger.error(this.getErrorMessage(httpRequest));
                HttpError error = exception instanceof TimeoutException ? HttpError.TIMEOUT : HttpError.CONNECTIVITY;
                callback.error((Throwable)((Object)new HttpRequestFailedException(I18nMessageFactory.createStaticMessage((String)this.errorMessageGenerator.createFrom(httpRequest, exception.getMessage())), (Throwable)exception, error)));
            }
        });
    }

    private String getErrorMessage(HttpRequest httpRequest) {
        return String.format("Error sending HTTP request to %s", httpRequest.getUri());
    }

    private boolean resendRequest(Result result, boolean retry, HttpRequestAuthentication authentication) throws MuleException {
        return retry && authentication != null && authentication.shouldRetry((Result<Object, HttpResponseAttributes>)result);
    }

    private void consumePayload(Result result) {
        if (result.getOutput() instanceof InputStream) {
            try {
                IOUtils.toByteArray((InputStream)((InputStream)result.getOutput()));
            }
            catch (Exception e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
    }

    private HttpAuthentication resolveAuthentication(HttpRequestAuthentication authentication) {
        HttpAuthentication requestAuthentication = null;
        if (authentication instanceof UsernamePasswordAuthentication) {
            requestAuthentication = (HttpAuthentication)authentication;
        }
        return requestAuthentication;
    }

    private void checkIfRemotelyClosed(Throwable exception, UriParameters uriParameters) {
        if (HttpConstants.Protocol.HTTPS.equals((Object)uriParameters.getScheme()) && StringUtils.containsIgnoreCase((CharSequence)exception.getMessage(), (CharSequence)"Remotely closed")) {
            logger.error("Remote host closed connection. Possible SSL/TLS handshake issue. Check protocols, cipher suites and certificate set up. Use -Djavax.net.debug=ssl for further debugging.");
        }
    }

    private boolean shouldRetryRemotelyClosed(Throwable exception, int retryCount, String httpMethod) {
        boolean shouldRetry;
        boolean bl = shouldRetry = exception instanceof IOException && StringUtils.containsIgnoreCase((CharSequence)exception.getMessage(), (CharSequence)"Remotely closed") && HttpConnectorConstants.IDEMPOTENT_METHODS.contains(httpMethod) && retryCount > 0;
        if (shouldRetry) {
            logger.warn("Sending HTTP message failed with `" + IOException.class.getCanonicalName() + ": " + "Remotely closed" + "`. Request will be retried " + retryCount + " time(s) before failing.");
        }
        return shouldRetry;
    }

    public static class Builder {
        private String uri;
        private String method;
        private boolean followRedirects;
        private HttpStreamingType requestStreamingMode;
        private HttpSendBodyMode sendBodyMode;
        private HttpRequestAuthentication authentication;
        private int responseTimeout;
        private ResponseValidator responseValidator;
        private HttpRequesterConfig config;
        private TransformationService transformationService;
        private Scheduler scheduler;
        private NotificationEmitter notificationEmitter;

        public Builder setUri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder setMethod(String method) {
            this.method = method;
            return this;
        }

        public Builder setFollowRedirects(boolean followRedirects) {
            this.followRedirects = followRedirects;
            return this;
        }

        public Builder setRequestStreamingMode(HttpStreamingType requestStreamingMode) {
            this.requestStreamingMode = requestStreamingMode;
            return this;
        }

        public Builder setSendBodyMode(HttpSendBodyMode sendBodyMode) {
            this.sendBodyMode = sendBodyMode;
            return this;
        }

        public Builder setAuthentication(HttpRequestAuthentication authentication) {
            this.authentication = authentication;
            return this;
        }

        public Builder setResponseTimeout(int responseTimeout) {
            this.responseTimeout = responseTimeout;
            return this;
        }

        public Builder setResponseValidator(ResponseValidator responseValidator) {
            this.responseValidator = responseValidator;
            return this;
        }

        public Builder setConfig(HttpRequesterConfig config) {
            this.config = config;
            return this;
        }

        public Builder setTransformationService(TransformationService transformationService) {
            this.transformationService = transformationService;
            return this;
        }

        public Builder setScheduler(Scheduler scheduler) {
            this.scheduler = scheduler;
            return this;
        }

        public Builder setNotificationEmitter(NotificationEmitter notificationEmitter) {
            this.notificationEmitter = notificationEmitter;
            return this;
        }

        public HttpRequester build() {
            HttpRequestFactory eventToHttpRequest = new HttpRequestFactory(this.config, this.uri, this.method, this.requestStreamingMode, this.sendBodyMode, this.transformationService);
            return new HttpRequester(eventToHttpRequest, this.followRedirects, this.authentication, this.responseTimeout, this.responseValidator, this.config, this.scheduler, this.notificationEmitter);
        }
    }
}

