/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public class HttpRequesterConnectionManager
implements Disposable {
    @Inject
    private HttpService httpService;
    private Map<String, HttpClient> clients = new HashMap<String, HttpClient>();

    public HttpRequesterConnectionManager() {
    }

    public HttpRequesterConnectionManager(HttpService httpService) {
        this.httpService = httpService;
    }

    public Optional<HttpClient> lookup(String configName) {
        return Optional.ofNullable(this.clients.get(configName));
    }

    public synchronized HttpClient create(String configName, HttpClientConfiguration clientConfiguration) {
        Preconditions.checkArgument((!this.clients.containsKey(configName) ? 1 : 0) != 0, (String)String.format("There's an HttpClient available for %s already.", configName));
        ShareableHttpClient client = new ShareableHttpClient(this.httpService.getClientFactory().create(clientConfiguration));
        this.clients.put(configName, client);
        return client;
    }

    public void dispose() {
        this.clients.clear();
    }

    private class ShareableHttpClient
    implements HttpClient {
        private HttpClient delegate;
        private AtomicInteger usageCount = new AtomicInteger(0);

        ShareableHttpClient(HttpClient client) {
            this.delegate = client;
        }

        public void start() {
            if (this.usageCount.incrementAndGet() == 1) {
                this.delegate.start();
            }
        }

        public void stop() {
            if (this.usageCount.decrementAndGet() == 0) {
                this.delegate.stop();
            }
        }

        public HttpResponse send(HttpRequest request, int responseTimeout, boolean followRedirects, HttpAuthentication authentication) throws IOException, TimeoutException {
            return this.delegate.send(request, responseTimeout, followRedirects, authentication);
        }

        public CompletableFuture<HttpResponse> sendAsync(HttpRequest request, int responseTimeout, boolean followRedirects, HttpAuthentication authentication) {
            return this.delegate.sendAsync(request, responseTimeout, followRedirects, authentication);
        }
    }
}

