/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request;

import java.util.Optional;
import javax.inject.Inject;
import org.mule.extension.http.api.request.authentication.HttpRequestAuthentication;
import org.mule.extension.http.api.request.proxy.HttpProxyConfig;
import org.mule.extension.http.internal.request.HttpRequesterConnectionManager;
import org.mule.extension.http.internal.request.RequestConnectionParams;
import org.mule.extension.http.internal.request.client.DefaultUriParameters;
import org.mule.extension.http.internal.request.client.HttpExtensionClient;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.tls.TlsContextFactoryBuilder;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.connectivity.NoConnectivityTest;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.api.tcp.TcpClientSocketProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="request")
public class HttpRequesterProvider
implements CachedConnectionProvider<HttpExtensionClient>,
Initialisable,
Disposable,
NoConnectivityTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRequesterProvider.class);
    private static final int UNLIMITED_CONNECTIONS = -1;
    private static final String NAME_PATTERN = "http.requester.%s";
    @Inject
    private MuleContext muleContext;
    @RefName
    private String configName;
    @ParameterGroup(name="Connection")
    private RequestConnectionParams connectionParams;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="TLS Configuration")
    @Placement(tab="TLS")
    private TlsContextFactory tlsContext;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Summary(value="Reusable configuration element for outbound connections through a proxy")
    @Placement(tab="Proxy")
    private HttpProxyConfig proxyConfig;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Placement(tab="Authentication")
    private HttpRequestAuthentication authentication;
    @Inject
    private HttpRequesterConnectionManager connectionManager;
    private TlsContextFactoryBuilder defaultTlsContextFactoryBuilder = TlsContextFactory.builder();

    public ConnectionValidationResult validate(HttpExtensionClient httpClient) {
        return ConnectionValidationResult.success();
    }

    public void initialise() throws InitialisationException {
        HttpConstants.Protocol protocol = this.connectionParams.getProtocol();
        if (this.connectionParams.getPort() == null) {
            this.connectionParams.setPort(protocol.getDefaultPort());
        }
        if (protocol.equals((Object)HttpConstants.Protocol.HTTP) && this.tlsContext != null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"TlsContext cannot be configured with protocol HTTP, when using tls:context you must set attribute protocol=\"HTTPS\""), (Initialisable)this);
        }
        if (protocol.equals((Object)HttpConstants.Protocol.HTTPS) && this.tlsContext == null) {
            LifecycleUtils.initialiseIfNeeded((Object)this.defaultTlsContextFactoryBuilder);
            this.tlsContext = this.defaultTlsContextFactoryBuilder.buildDefault();
        }
        if (this.tlsContext != null) {
            LifecycleUtils.initialiseIfNeeded((Object)this.tlsContext);
        }
        if (this.authentication != null) {
            LifecycleUtils.initialiseIfNeeded((Object)this.authentication, (boolean)true, (MuleContext)this.muleContext);
        }
        this.verifyConnectionsParameters();
    }

    public void dispose() {
        if (this.authentication != null) {
            LifecycleUtils.disposeIfNeeded((Object)this.authentication, (Logger)LOGGER);
        }
    }

    private void verifyConnectionsParameters() throws InitialisationException {
        if (this.connectionParams.getMaxConnections() < -1 || this.connectionParams.getMaxConnections() == 0) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"The maxConnections parameter only allows positive values or -1 for unlimited concurrent connections."), (Initialisable)this);
        }
        if (!this.connectionParams.getUsePersistentConnections()) {
            this.connectionParams.setConnectionIdleTimeout(0);
        }
    }

    public HttpExtensionClient connect() throws ConnectionException {
        HttpClient httpClient;
        Optional<HttpClient> client = this.connectionManager.lookup(this.configName);
        if (client.isPresent()) {
            httpClient = client.get();
        } else {
            String name = String.format(NAME_PATTERN, this.configName);
            HttpClientConfiguration configuration = new HttpClientConfiguration.Builder().setTlsContextFactory(this.tlsContext).setProxyConfig((ProxyConfig)this.proxyConfig).setClientSocketProperties(this.buildTcpProperties(this.connectionParams.getClientSocketProperties())).setMaxConnections(this.connectionParams.getMaxConnections().intValue()).setUsePersistentConnections(this.connectionParams.getUsePersistentConnections()).setConnectionIdleTimeout(this.connectionParams.getConnectionIdleTimeout().intValue()).setStreaming(this.connectionParams.getStreamResponse()).setResponseBufferSize(this.connectionParams.getResponseBufferSize()).setName(name).build();
            httpClient = this.connectionManager.create(this.configName, configuration);
        }
        DefaultUriParameters uriParameters = new DefaultUriParameters(this.connectionParams.getProtocol(), this.connectionParams.getHost(), this.connectionParams.getPort());
        HttpExtensionClient extensionClient = new HttpExtensionClient(httpClient, uriParameters, this.authentication);
        try {
            extensionClient.start();
        }
        catch (MuleException e) {
            throw new ConnectionException((Throwable)e);
        }
        return extensionClient;
    }

    private TcpClientSocketProperties buildTcpProperties(org.mule.extension.socket.api.socket.tcp.TcpClientSocketProperties socketProperties) {
        return TcpClientSocketProperties.builder().sendBufferSize(socketProperties.getSendBufferSize()).sendBufferSize(socketProperties.getSendBufferSize()).clientTimeout(socketProperties.getClientTimeout()).sendTcpNoDelay(Boolean.valueOf(socketProperties.getSendTcpNoDelay())).linger(socketProperties.getLinger()).keepAlive(Boolean.valueOf(socketProperties.getKeepAlive())).connectionTimeout(Integer.valueOf(socketProperties.getConnectionTimeout())).build();
    }

    public void disconnect(HttpExtensionClient httpClient) {
        block2: {
            try {
                httpClient.stop();
            }
            catch (MuleException e) {
                if (!LOGGER.isWarnEnabled()) break block2;
                LOGGER.warn("Found exception trying to stop http client: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public RequestConnectionParams getConnectionParams() {
        return this.connectionParams;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public TlsContextFactory getTlsContext() {
        return this.tlsContext;
    }

    public HttpRequestAuthentication getAuthentication() {
        return this.authentication;
    }
}

