/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.extension.http.internal.request.HttpRequesterCookieConfig;
import org.mule.extension.http.internal.request.builder.HttpResponseAttributesBuilder;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.api.util.SystemUtils;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class HttpResponseToResult {
    private static final Logger logger = LoggerFactory.getLogger(HttpResponseToResult.class);
    private final HttpRequesterCookieConfig config;
    private final MuleContext muleContext;

    public HttpResponseToResult(HttpRequesterCookieConfig config, MuleContext muleContext) {
        this.config = config;
        this.muleContext = muleContext;
    }

    public Publisher<Result<InputStream, HttpResponseAttributes>> convert(HttpResponse response, URI uri) {
        String responseContentType = response.getHeaderValueIgnoreCase("Content-Type");
        HttpEntity entity = response.getEntity();
        if (StringUtils.isEmpty((String)responseContentType) && this.notEmpty(entity)) {
            responseContentType = MediaType.BINARY.toRfcString();
        }
        MediaType responseMediaType = HttpResponseToResult.getMediaType(responseContentType, SystemUtils.getDefaultEncoding((MuleContext)this.muleContext));
        if (this.config.isEnableCookies()) {
            this.processCookies(response, uri);
        }
        HttpResponseAttributes responseAttributes = this.createAttributes(response);
        Result.Builder builder = Result.builder();
        builder.mediaType(responseMediaType);
        if (entity.getLength().isPresent()) {
            builder.length((Long)entity.getLength().get());
        }
        return Mono.just((Object)builder.output((Object)entity.getContent()).attributes((Object)responseAttributes).build());
    }

    private boolean notEmpty(HttpEntity entity) {
        return entity.getLength().map(length -> length > 0L).orElse(true);
    }

    private HttpResponseAttributes createAttributes(HttpResponse response) {
        return new HttpResponseAttributesBuilder().setResponse(response).build();
    }

    private void processCookies(HttpResponse response, URI uri) {
        Collection setCookieHeader = response.getHeaderValuesIgnoreCase("Set-Cookie");
        Collection setCookie2Header = response.getHeaderValuesIgnoreCase("Set-Cookie2");
        HashMap<String, List<String>> cookieHeaders = new HashMap<String, List<String>>();
        if (setCookieHeader != null) {
            cookieHeaders.put("Set-Cookie", new ArrayList(setCookieHeader));
        }
        if (setCookie2Header != null) {
            cookieHeaders.put("Set-Cookie2", new ArrayList(setCookie2Header));
        }
        try {
            this.config.getCookieManager().put(uri, cookieHeaders);
        }
        catch (IOException e) {
            logger.warn("Error storing cookies for URI " + uri, (Throwable)e);
        }
    }

    private static MediaType getMediaType(String contentTypeValue, Charset defaultCharset) {
        MediaType mediaType = MediaType.ANY;
        if (contentTypeValue != null) {
            try {
                mediaType = MediaType.parse((String)contentTypeValue);
            }
            catch (IllegalArgumentException e) {
                if (Boolean.parseBoolean(System.getProperty("mule.strictContentType"))) {
                    throw e;
                }
                logger.warn(String.format("%s when parsing Content-Type '%s': %s", e.getClass().getName(), contentTypeValue, e.getMessage()));
                logger.warn(String.format("Using default encoding: %s", Charset.defaultCharset().name()));
            }
        }
        if (!mediaType.getCharset().isPresent()) {
            return mediaType.withCharset(defaultCharset);
        }
        return mediaType;
    }
}

