/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.api.listener.headers;

import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import org.mule.extension.http.api.listener.headers.HttpHeadersException;
import org.mule.extension.http.api.listener.headers.HttpHeadersValidator;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.HttpConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvalidTransferEncodingValidator
implements HttpHeadersValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(InvalidTransferEncodingValidator.class);
    private static final String TRANSFER_ENCODING_LOWERCASE = "Transfer-Encoding".toLowerCase(Locale.ROOT);
    private static final int ERRORS_LIMIT_TO_PRINT_WARNING = 0x200000;
    private static final String CHUNKED_LOWER_CASE = "chunked";
    private static final String DEFLATE_LOWER_CASE = "deflate";
    private static final String COMPRESS_LOWER_CASE = "compress";
    private static final String IDENTITY_LOWER_CASE = "identity";
    private static final String GZIP_LOWER_CASE = "gzip";
    private static final int CHUNKED_AND_DEFLATE_LENGTH = 7;
    private static final int COMPRESS_AND_IDENTITY_LENGTH = 8;
    private static final int GZIP_LENGTH = 4;
    private final boolean throwException;
    private final AtomicInteger errorsFound = new AtomicInteger();

    public InvalidTransferEncodingValidator(boolean throwException) {
        this.throwException = throwException;
    }

    @Override
    public void validateHeaders(MultiMap<String, String> headers) throws HttpHeadersException {
        List allTransferEncodings = headers.getAll((Object)TRANSFER_ENCODING_LOWERCASE);
        int numberOfTransferEncodings = allTransferEncodings.size();
        if (numberOfTransferEncodings == 0) {
            return;
        }
        if (numberOfTransferEncodings == 1) {
            if (!InvalidTransferEncodingValidator.isValidTransferEncodingHeader((String)allTransferEncodings.get(0))) {
                this.reportError();
            }
            return;
        }
        for (String header : allTransferEncodings) {
            if (InvalidTransferEncodingValidator.isValidTransferEncodingHeader(header)) continue;
            this.reportError();
        }
    }

    private void reportError() throws HttpHeadersException {
        if (this.throwException) {
            throw new HttpHeadersException(String.format("'%s' header has an invalid value", "Transfer-Encoding"), HttpConstants.HttpStatus.BAD_REQUEST);
        }
        if (this.errorsFound.getAndIncrement() % 0x200000 == 0) {
            LOGGER.warn("'{}' header has an invalid value", (Object)"Transfer-Encoding");
        } else {
            LOGGER.trace("'{}' header has an invalid value", (Object)"Transfer-Encoding");
        }
    }

    private static boolean isValidTransferEncodingHeader(String headerValue) {
        if (CHUNKED_LOWER_CASE.equals(headerValue)) {
            return true;
        }
        if (headerValue.contains(",")) {
            for (String singleTransferEncoding : headerValue.split(",")) {
                if (InvalidTransferEncodingValidator.isSingleHeaderValid(singleTransferEncoding)) continue;
                return false;
            }
            return true;
        }
        return InvalidTransferEncodingValidator.isSingleHeaderValid(headerValue);
    }

    private static boolean isSingleHeaderValid(String transferEncoding) {
        String trimmed = transferEncoding.trim();
        int size = trimmed.length();
        switch (size) {
            case 7: {
                return CHUNKED_LOWER_CASE.equalsIgnoreCase(trimmed) || DEFLATE_LOWER_CASE.equalsIgnoreCase(trimmed);
            }
            case 8: {
                return COMPRESS_LOWER_CASE.equalsIgnoreCase(trimmed) || IDENTITY_LOWER_CASE.equalsIgnoreCase(trimmed);
            }
            case 4: {
                return GZIP_LOWER_CASE.equalsIgnoreCase(trimmed);
            }
        }
        return false;
    }
}

