/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.api.request;

import java.io.InputStream;
import java.net.CookieManager;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.extension.http.api.request.HttpSendBodyMode;
import org.mule.extension.http.api.request.authentication.HttpRequestAuthentication;
import org.mule.extension.http.api.request.builder.HttpRequesterTestRequestBuilder;
import org.mule.extension.http.api.request.builder.TestQueryParam;
import org.mule.extension.http.api.request.builder.TestRequestHeader;
import org.mule.extension.http.api.request.builder.UriParam;
import org.mule.extension.http.api.request.validator.ResponseValidator;
import org.mule.extension.http.api.request.validator.ResponseValidatorTypedException;
import org.mule.extension.http.api.request.validator.SuccessStatusCodeValidator;
import org.mule.extension.http.internal.request.HttpRequesterCookieConfig;
import org.mule.extension.http.internal.request.HttpResponseToResult;
import org.mule.extension.http.internal.request.KeyValuePairUtils;
import org.mule.extension.http.internal.request.RequestConnectionParams;
import org.mule.extension.http.internal.request.UriUtils;
import org.mule.extension.http.internal.request.client.HttpExtensionClient;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Text;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.parameter.Literal;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public class HttpConnectivityValidator
implements Initialisable {
    @Parameter
    @DisplayName(value="Test Request Path")
    @Placement(order=1)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private String requestPath = "/";
    @Parameter
    @DisplayName(value="Request HTTP Method")
    @Optional(defaultValue="GET")
    @Placement(order=2)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private String requestMethod = "GET";
    @Parameter
    @Optional(defaultValue="true")
    @Placement(order=3)
    private boolean followRedirects = true;
    @Parameter
    @Optional(defaultValue="10000")
    @Placement(order=4)
    private Integer responseTimeout = 10000;
    @Parameter
    @Optional(defaultValue="MILLISECONDS")
    @Placement(order=5)
    private TimeUnit responseTimeoutUnit = TimeUnit.MILLISECONDS;
    @Parameter
    @Optional
    @Placement(order=6)
    @Text
    @Expression(value=ExpressionSupport.SUPPORTED)
    @DisplayName(value="Body")
    private Literal<String> requestBody;
    @Parameter
    @Optional
    @Placement(order=7)
    @NullSafe
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Headers")
    private List<TestRequestHeader> requestHeaders = Collections.emptyList();
    @Parameter
    @Optional
    @Placement(order=8)
    @NullSafe
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Query Parameters")
    private List<TestQueryParam> requestQueryParams = Collections.emptyList();
    @Parameter
    @Optional
    @Placement(order=9)
    @NullSafe
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="URI Parameters")
    private List<UriParam> requestUriParams = Collections.emptyList();
    @Parameter
    @Optional
    @DisplayName(value="Response Validator")
    @Placement(order=10)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private ResponseValidator responseValidator;
    @Inject
    private ExpressionManager expressionManager;
    private HttpRequesterTestRequestBuilder requestBuilder = new HttpRequesterTestRequestBuilder(this.requestBody, this.requestHeaders, this.requestQueryParams, this.requestUriParams, this.expressionManager);
    private SuccessStatusCodeValidator defaultStatusCodeValidator = new SuccessStatusCodeValidator("0..399");
    @Inject
    private MuleContext muleContext;

    public void validate(HttpExtensionClient client, RequestConnectionParams connectionParams) throws ExecutionException, InterruptedException, ResponseValidatorTypedException {
        HttpRequest request = this.buildTestRequest(connectionParams);
        Result<Object, HttpResponseAttributes> result = this.sendRequest(client, request);
        this.validateResult(request, result);
    }

    protected void validateResult(HttpRequest request, Result result) {
        this.getResponseValidator().validate((Result<InputStream, HttpResponseAttributes>)result, request);
    }

    protected Result<Object, HttpResponseAttributes> sendRequest(HttpExtensionClient client, HttpRequest request) throws InterruptedException, ExecutionException {
        int responseTimeoutInt = (int)this.responseTimeoutUnit.toMillis(this.responseTimeout.longValue());
        HttpResponse response = client.send(request, responseTimeoutInt, this.followRedirects, HttpConnectivityValidator.resolveAuthentication(client), HttpSendBodyMode.AUTO).get();
        return new HttpResponseToResult().convert(new VoidHttpRequesterCookieConfig(), this.muleContext, response, response.getEntity(), () -> ((HttpEntity)response.getEntity()).getContent(), request.getUri());
    }

    private HttpRequest buildTestRequest(RequestConnectionParams connectionParams) {
        String uriString = this.getUriString(connectionParams);
        return ((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri(uriString).method(this.requestMethod).headers(KeyValuePairUtils.toMultiMap(this.requestBuilder.getRequestHeaders()))).queryParams(KeyValuePairUtils.toMultiMap(this.requestBuilder.getRequestQueryParams())).entity(this.requestBuilder.buildEntity())).build();
    }

    private String getUriString(RequestConnectionParams connectionParams) {
        String pathWithUriParams = UriUtils.replaceUriParams(this.requestPath, this.requestBuilder.getRequestUriParams());
        return connectionParams.getProtocol().getScheme() + "://" + connectionParams.getHost() + ":" + connectionParams.getPort() + pathWithUriParams;
    }

    protected ResponseValidator getResponseValidator() {
        return this.responseValidator == null ? this.defaultStatusCodeValidator : this.responseValidator;
    }

    protected String getRequestPath() {
        return this.requestPath;
    }

    protected String getRequestMethod() {
        return this.requestMethod;
    }

    protected HttpRequesterTestRequestBuilder getRequestBuilder() {
        return this.requestBuilder;
    }

    public void initialise() throws InitialisationException {
        if (this.responseValidator != null) {
            LifecycleUtils.initialiseIfNeeded((Object)this.responseValidator, (boolean)true, (MuleContext)this.muleContext);
        }
        this.requestBuilder = new HttpRequesterTestRequestBuilder(this.requestBody, this.requestHeaders, this.requestQueryParams, this.requestUriParams, this.expressionManager);
    }

    private static HttpAuthentication resolveAuthentication(HttpExtensionClient client) {
        HttpRequestAuthentication authentication = client.getDefaultAuthentication();
        if (authentication instanceof HttpAuthentication) {
            return (HttpAuthentication)authentication;
        }
        return null;
    }

    private static class VoidHttpRequesterCookieConfig
    implements HttpRequesterCookieConfig {
        private VoidHttpRequesterCookieConfig() {
        }

        @Override
        public boolean isEnableCookies() {
            return false;
        }

        @Override
        public CookieManager getCookieManager() {
            return null;
        }
    }
}

