/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.api.request.builder;

import java.util.Collections;
import java.util.Map;
import org.mule.extension.http.api.HttpMessageBuilder;
import org.mule.extension.http.internal.request.HttpRequesterConfig;
import org.mule.extension.http.internal.request.UriUtils;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.runtime.parameter.CorrelationInfo;
import org.mule.runtime.extension.api.runtime.parameter.OutboundCorrelationStrategy;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.server.HttpServerProperties;

public class HttpRequesterRequestBuilder
extends HttpMessageBuilder {
    @Parameter
    @Content(primary=true)
    private TypedValue<Object> body;
    @Parameter
    @Optional
    @Content
    @NullSafe
    protected MultiMap<String, String> headers = MultiMap.emptyMultiMap();
    @Parameter
    @Optional
    @Content
    @DisplayName(value="URI Parameters")
    private Map<String, String> uriParams = Collections.emptyMap();
    @Parameter
    @Optional
    @Content
    @DisplayName(value="Query Parameters")
    private MultiMap<String, String> queryParams = MultiMap.emptyMultiMap();
    @Parameter
    @ConfigOverride
    private OutboundCorrelationStrategy sendCorrelationId = OutboundCorrelationStrategy.AUTO;
    @Parameter
    @Optional
    private String correlationId;
    private CorrelationInfo correlationInfo;

    @Override
    public TypedValue<Object> getBody() {
        return this.body;
    }

    @Override
    public void setBody(TypedValue<Object> body) {
        this.body = body;
    }

    @Override
    public MultiMap<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public void setHeaders(MultiMap<String, String> headers) {
        this.headers = headers != null ? headers : MultiMap.emptyMultiMap();
    }

    public String replaceUriParams(String path) {
        return UriUtils.replaceUriParams(path, this.uriParams);
    }

    public MultiMap<String, String> getQueryParams() {
        return this.queryParams.toImmutableMultiMap();
    }

    public Map<String, String> getUriParams() {
        return Collections.unmodifiableMap(this.uriParams);
    }

    public void setQueryParams(MultiMap<String, String> queryParams) {
        this.queryParams = queryParams;
    }

    public void setUriParams(Map<String, String> uriParams) {
        this.uriParams = uriParams;
    }

    public void setCorrelationInfo(CorrelationInfo correlationInfo) {
        this.correlationInfo = correlationInfo;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public CorrelationInfo getCorrelationInfo() {
        return this.correlationInfo;
    }

    public OutboundCorrelationStrategy getSendCorrelationId() {
        return this.sendCorrelationId;
    }

    @Deprecated
    public HttpRequestBuilder configure(HttpRequesterConfig config) {
        return this.toHttpRequestBuilder(config);
    }

    public HttpRequestBuilder toHttpRequestBuilder(HttpRequesterConfig config) {
        return ((HttpRequestBuilder)HttpRequest.builder((HttpServerProperties.PRESERVE_HEADER_CASE || config.isPreserveHeadersCase() ? 1 : 0) != 0).headers(this.headers)).queryParams(this.queryParams);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private TypedValue<Object> body;
        private MultiMap<String, String> headers = MultiMap.emptyMultiMap();
        private Map<String, String> uriParams = Collections.emptyMap();
        private MultiMap<String, String> queryParams = MultiMap.emptyMultiMap();
        private OutboundCorrelationStrategy sendCorrelationId = OutboundCorrelationStrategy.AUTO;
        private String correlationId;
        private CorrelationInfo correlationInfo;

        public Builder withBody(TypedValue<Object> body) {
            this.body = body;
            return this;
        }

        public Builder withHeaders(MultiMap<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder withUriParams(Map<String, String> uriParams) {
            this.uriParams = uriParams;
            return this;
        }

        public Builder withQueryParams(MultiMap<String, String> queryParams) {
            this.queryParams = queryParams;
            return this;
        }

        public Builder withSendCorrelationId(OutboundCorrelationStrategy sendCorrelationId) {
            this.sendCorrelationId = sendCorrelationId;
            return this;
        }

        public Builder withCorrelationId(String correlationId) {
            this.correlationId = correlationId;
            return this;
        }

        public Builder with(CorrelationInfo correlationInfo) {
            this.correlationInfo = correlationInfo;
            return this;
        }

        public HttpRequesterRequestBuilder build() {
            HttpRequesterRequestBuilder b = new HttpRequesterRequestBuilder();
            b.body = this.body;
            b.headers = this.headers;
            b.uriParams = this.uriParams;
            b.queryParams = this.queryParams;
            b.sendCorrelationId = this.sendCorrelationId;
            b.correlationId = this.correlationId;
            b.correlationInfo = this.correlationInfo;
            return b;
        }
    }
}

