/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.listener.profiling.tracing;

import java.net.URI;
import java.net.URISyntaxException;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.extension.http.internal.request.profiling.tracing.HttpCurrentSpanCustomizer;
import org.mule.sdk.api.runtime.source.DistributedTraceContextManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpListenerCurrentSpanCustomizer
extends HttpCurrentSpanCustomizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpListenerCurrentSpanCustomizer.class);
    public static final String HTTP_TARGET = "http.target";
    public static final String NET_HOST_NAME = "net.host.name";
    public static final String NET_HOST_PORT = "net.host.port";
    public static final String HTTP_USER_AGENT = "http.user_agent";
    public static final String HTTP_SCHEME = "http.scheme";
    public static final String HTTP_ROUTE = "http.route";
    private static final String SPAN_KIND_NAME = "SERVER";
    private final HttpRequestAttributes attributes;
    private final String host;
    private final int port;

    private HttpListenerCurrentSpanCustomizer(HttpRequestAttributes attributes, String host, int port) {
        this.attributes = attributes;
        this.host = host;
        this.port = port;
    }

    public static HttpCurrentSpanCustomizer getHttpListenerCurrentSpanCustomizer(HttpRequestAttributes attributes, String host, int port) {
        return new HttpListenerCurrentSpanCustomizer(attributes, host, port);
    }

    @Override
    public void customizeSpan(DistributedTraceContextManager distributedTraceContextManager) {
        super.customizeSpan(distributedTraceContextManager);
        try {
            distributedTraceContextManager.addCurrentSpanAttribute(HTTP_TARGET, this.attributes.getListenerPath());
            distributedTraceContextManager.addCurrentSpanAttribute(NET_HOST_NAME, this.host);
            distributedTraceContextManager.addCurrentSpanAttribute(NET_HOST_PORT, String.valueOf(this.getURI().getPort()));
            distributedTraceContextManager.addCurrentSpanAttribute(HTTP_SCHEME, this.attributes.getScheme());
            distributedTraceContextManager.addCurrentSpanAttribute(HTTP_ROUTE, this.attributes.getListenerPath());
            String userAgent = (String)this.attributes.getHeaders().get((Object)"User-Agent");
            if (userAgent != null) {
                distributedTraceContextManager.addCurrentSpanAttribute(HTTP_USER_AGENT, userAgent);
            }
        }
        catch (Throwable e) {
            LOGGER.warn("Error on setting listener span attributes.", e);
        }
    }

    @Override
    public String getProtocol() {
        return this.attributes.getScheme().toUpperCase();
    }

    @Override
    public String getMethod() {
        return this.attributes.getMethod().toUpperCase();
    }

    @Override
    public String getFlavor() {
        return this.resolveFlavor(this.attributes.getVersion());
    }

    private String resolveFlavor(String version) {
        if (version == null) {
            return null;
        }
        return version.substring(version.indexOf("/") + 1);
    }

    @Override
    public URI getURI() throws URISyntaxException {
        return new URI(this.attributes.getScheme(), null, this.host, this.port, this.attributes.getListenerPath(), null, null);
    }

    @Override
    protected String getSpanKind() {
        return SPAN_KIND_NAME;
    }

    @Override
    protected String getSpanName() {
        return this.attributes.getMethod() + " " + this.attributes.getListenerPath();
    }
}

