/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.extension.http.api.request.builder.KeyValuePair;
import org.mule.extension.http.api.request.builder.SimpleQueryParam;
import org.mule.extension.http.api.request.builder.SimpleRequestHeader;
import org.mule.extension.http.api.request.builder.SimpleUriParam;
import org.mule.extension.http.internal.request.KeyValuePairUtils;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.el.ValidationResult;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.runtime.operation.Result;

public final class HttpPollingSourceUtils {
    private HttpPollingSourceUtils() {
    }

    private static BindingContext buildContext(Optional<TypedValue<String>> payload, Optional<HttpResponseAttributes> attributes, Serializable currentWatermark, Optional<TypedValue> item) {
        BindingContext.Builder builder = BindingContext.builder();
        payload.ifPresent(p -> builder.addBinding("payload", p));
        attributes.ifPresent(attr -> builder.addBinding("attributes", TypedValue.of((Object)attr)));
        builder.addBinding("watermark", TypedValue.of((Object)currentWatermark));
        item.ifPresent(it -> builder.addBinding("item", it));
        return builder.build();
    }

    private static BindingContext buildContextForRequest(Serializable watermark) {
        return HttpPollingSourceUtils.buildContext(Optional.empty(), Optional.empty(), watermark, Optional.empty());
    }

    private static Result<TypedValue<?>, HttpResponseAttributes> toResult(TypedValue<?> item, MediaType mediaType, HttpResponseAttributes attributes) {
        return Result.builder().attributes((Object)attributes).output(item).mediaType(mediaType).build();
    }

    private static boolean isJavaPayload(MediaType mediaType) {
        return mediaType.matches(MediaType.APPLICATION_JAVA);
    }

    public static Stream<Result<TypedValue<?>, HttpResponseAttributes>> getItems(TypedValue<String> payload, HttpResponseAttributes attributes, Serializable currentWatermark, Optional<String> itemsExpression, ExpressionLanguage expressionLanguage) {
        if (HttpPollingSourceUtils.isJavaPayload(payload.getDataType().getMediaType())) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("%s is not an accepted media type", MediaType.APPLICATION_JAVA.toRfcString())));
        }
        if (!itemsExpression.isPresent()) {
            return Stream.of(HttpPollingSourceUtils.toResult(payload, payload.getDataType().getMediaType(), attributes));
        }
        Iterable splitted = () -> expressionLanguage.split((String)itemsExpression.get(), HttpPollingSourceUtils.buildContext(Optional.of(payload), Optional.of(attributes), currentWatermark, Optional.empty()));
        return StreamSupport.stream(splitted.spliterator(), false).map(item -> HttpPollingSourceUtils.toResult(item, item.getDataType().getMediaType(), attributes));
    }

    public static Serializable getItemWatermark(TypedValue<String> payload, String watermarkExpression, Serializable currentWatermark, Result<TypedValue<?>, HttpResponseAttributes> item, ExpressionLanguage expressionLanguage) {
        return (Serializable)HttpPollingSourceUtils.resolveExpression(payload, watermarkExpression, currentWatermark, item, expressionLanguage).getValue();
    }

    public static String getItemId(TypedValue<String> payload, String idExpression, Serializable currentWatermark, Result<TypedValue<?>, HttpResponseAttributes> item, ExpressionLanguage expressionLanguage) {
        return (String)HttpPollingSourceUtils.resolveExpression(payload, idExpression, currentWatermark, item, expressionLanguage).getValue();
    }

    private static TypedValue<?> resolveExpression(TypedValue<String> payload, String idExpression, Serializable currentWatermark, Result<TypedValue<?>, HttpResponseAttributes> item, ExpressionLanguage expressionLanguage) {
        return expressionLanguage.evaluate(idExpression, DataType.STRING, HttpPollingSourceUtils.buildContext(Optional.of(payload), item.getAttributes(), currentWatermark, Optional.of(item.getOutput())));
    }

    public static TypedValue<?> resolveBody(String bodyExpression, Serializable currentWatermark, ExpressionLanguage expressionLanguage) {
        if (!HttpPollingSourceUtils.isExpression(bodyExpression)) {
            return TypedValue.of((Object)bodyExpression);
        }
        return expressionLanguage.evaluate(bodyExpression, HttpPollingSourceUtils.buildContextForRequest(currentWatermark));
    }

    public static MultiMap<String, String> resolveHeaders(List<SimpleRequestHeader> headers, Serializable currentWatermark, ExpressionLanguage expressionLanguage) {
        return KeyValuePairUtils.toMultiMap(headers.stream().map(pair -> new ResolvedKeyValue(pair.getKey(), HttpPollingSourceUtils.resolveIfExpression(pair.getValue(), currentWatermark, expressionLanguage))).collect(Collectors.toList()));
    }

    public static MultiMap<String, String> resolveQueryParams(List<SimpleQueryParam> queryParams, Serializable currentWatermark, ExpressionLanguage expressionLanguage) {
        return KeyValuePairUtils.toMultiMap(queryParams.stream().map(pair -> new ResolvedKeyValue(pair.getKey(), HttpPollingSourceUtils.resolveIfExpression(pair.getValue(), currentWatermark, expressionLanguage))).collect(Collectors.toList()));
    }

    public static Map<String, String> resolveUriParams(List<SimpleUriParam> uriParams, Serializable currentWatermark, ExpressionLanguage expressionLanguage) {
        return uriParams.stream().collect(Collectors.toMap(SimpleUriParam::getKey, up -> HttpPollingSourceUtils.resolveIfExpression(up.getValue(), currentWatermark, expressionLanguage)));
    }

    public static ValidationResult isValidExpression(String expression, ExpressionLanguage expressionLanguage) {
        if (!HttpPollingSourceUtils.isExpression(expression)) {
            return ValidationResult.success();
        }
        return expressionLanguage.validate(expression);
    }

    private static String resolveIfExpression(String exp, Serializable currentWatermark, ExpressionLanguage expressionLanguage) {
        if (!HttpPollingSourceUtils.isExpression(exp)) {
            return exp;
        }
        return expressionLanguage.evaluate(exp, HttpPollingSourceUtils.buildContextForRequest(currentWatermark)).getValue().toString();
    }

    private static boolean isExpression(String value) {
        String trim = value.trim();
        return trim.startsWith("#[") && trim.endsWith("]");
    }

    private static final class ResolvedKeyValue
    implements KeyValuePair {
        private String key;
        private String value;

        public ResolvedKeyValue(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

