/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.extension.http.api.request.builder.UriParam;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.utils.HttpEncoderDecoderUtils;

public final class UriUtils {
    private static final Pattern WRONGLY_ENCODED_SPACES = Pattern.compile("\\+");
    private static boolean ENCODE_URI_PARAMS = Boolean.getBoolean("mule.http.client.encodeUriParams");

    private UriUtils() {
    }

    public static String replaceUriParams(String path, Map<String, String> uriParams) {
        for (Map.Entry<String, String> entry : uriParams.entrySet()) {
            String uriParamName = entry.getKey();
            String uriParamValue = entry.getValue();
            path = UriUtils.replaceUriParam(path, uriParamName, uriParamValue);
        }
        return path;
    }

    public static String replaceUriParams(String path, List<? extends UriParam> uriParams) {
        for (UriParam uriParam : uriParams) {
            String uriParamName = uriParam.getKey();
            String uriParamValue = uriParam.getValue();
            path = UriUtils.replaceUriParam(path, uriParamName, uriParamValue);
        }
        return path;
    }

    private static String replaceUriParam(String path, String uriParamName, String uriParamValue) {
        if (uriParamValue == null) {
            throw new NullPointerException(String.format("Expression {%s} evaluated to null.", uriParamName));
        }
        if (ENCODE_URI_PARAMS) {
            try {
                uriParamValue = WRONGLY_ENCODED_SPACES.matcher(URLEncoder.encode(uriParamValue, StandardCharsets.UTF_8.displayName())).replaceAll("%20");
            }
            catch (UnsupportedEncodingException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not encode URI parameter '%s'", (Object[])new Object[]{uriParamValue}), (Throwable)e);
            }
        }
        path = path.replaceAll("\\{" + uriParamName + "\\}", Matcher.quoteReplacement(uriParamValue));
        return path;
    }

    public static String buildPath(String basePath, String path) {
        String resolvedBasePath = basePath;
        String resolvedRequestPath = path;
        if (!resolvedBasePath.startsWith("/")) {
            resolvedBasePath = "/" + resolvedBasePath;
        }
        if (resolvedBasePath.endsWith("/") && resolvedRequestPath.startsWith("/")) {
            resolvedBasePath = resolvedBasePath.substring(0, resolvedBasePath.length() - 1);
        }
        if (!(resolvedBasePath.endsWith("/") || resolvedRequestPath.startsWith("/") || resolvedRequestPath.isEmpty())) {
            resolvedBasePath = resolvedBasePath + "/";
        }
        return resolvedBasePath + resolvedRequestPath;
    }

    public static String resolveUri(HttpConstants.Protocol scheme, String host, Integer port, String path) {
        return scheme.getScheme() + "://" + host + ":" + port + HttpEncoderDecoderUtils.encodeSpaces((String)path);
    }

    public static void refreshSystemProperties() {
        ENCODE_URI_PARAMS = Boolean.getBoolean("mule.http.client.encodeUriParams");
    }
}

