/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request.profiling;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.runtime.api.profiling.type.context.ExtensionProfilingEventContext;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class HttpRequestProfilingEventContext
implements ExtensionProfilingEventContext {
    public static final String HTTP_CONNECTOR = "HTTP_CONNECTOR";
    public static final String HTTP_REQUEST_RESPONSE = "HTTP_REQUEST_RESPONSE";
    public static final String STATUS_CODE = "STATUS_CODE";
    public static final String CORRELATION_ID = "CORRELATION_ID";
    public static final String REASON_PHRASE = "REASON_PHRASE";
    private Result<Object, HttpResponseAttributes> result;
    private String correlationId;
    private final long triggerTimestamp;
    private final Map<String, Supplier<Optional<Object>>> profilingDataSuppliers = new HashMap<String, Supplier<Optional<Object>>>(){
        {
            this.put(HttpRequestProfilingEventContext.CORRELATION_ID, () -> Optional.ofNullable(HttpRequestProfilingEventContext.this.correlationId));
            this.put(HttpRequestProfilingEventContext.STATUS_CODE, () -> HttpRequestProfilingEventContext.this.result.getAttributes().map(HttpResponseAttributes::getStatusCode));
            this.put(HttpRequestProfilingEventContext.REASON_PHRASE, () -> HttpRequestProfilingEventContext.this.result.getAttributes().map(HttpResponseAttributes::getReasonPhrase));
        }
    };

    public HttpRequestProfilingEventContext(Result<Object, HttpResponseAttributes> result, String correlationId, long triggerTimestamp) {
        this.triggerTimestamp = triggerTimestamp;
        this.correlationId = correlationId;
        this.result = result;
    }

    public long getTriggerTimestamp() {
        return this.triggerTimestamp;
    }

    public String getProfilingDataSourceIdentifier() {
        return HTTP_CONNECTOR;
    }

    public String getExtensionEventSubtypeIdentifier() {
        return HTTP_REQUEST_RESPONSE;
    }

    public Optional<Object> get(String key) {
        if (this.profilingDataSuppliers.containsKey(key)) {
            return this.profilingDataSuppliers.get(key).get();
        }
        return Optional.empty();
    }
}

