/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request.profiling.tracing;

import org.mule.sdk.api.runtime.source.DistributedTraceContextManager;
import org.slf4j.Logger;

public class HttpSpanUtils {
    public static final String HTTP_STATUS_CODE = "http.status_code";
    public static final String SPAN_STATUS = "status.override";
    public static final String ERROR_STATUS = "ERROR";
    public static final String UNSET_STATUS = "UNSET";

    private HttpSpanUtils() {
    }

    public static void addStatusCodeAttribute(DistributedTraceContextManager distributedTraceContextManager, int statusCode, Logger logger) {
        try {
            if (distributedTraceContextManager != null) {
                distributedTraceContextManager.addCurrentSpanAttribute(HTTP_STATUS_CODE, String.valueOf(statusCode));
            }
        }
        catch (Throwable e) {
            logger.warn("An exception on processing the span http status code", e);
        }
    }

    public static void updateServerSpanStatus(DistributedTraceContextManager distributedTraceContextManager, int statusCode, Logger logger) {
        try {
            if (distributedTraceContextManager != null) {
                if (statusCode == 500) {
                    distributedTraceContextManager.addCurrentSpanAttribute(SPAN_STATUS, ERROR_STATUS);
                } else {
                    distributedTraceContextManager.addCurrentSpanAttribute(SPAN_STATUS, UNSET_STATUS);
                }
            }
        }
        catch (Throwable e) {
            logger.warn("An exception on updating the server span status", e);
        }
    }

    public static void updateClientSpanStatus(DistributedTraceContextManager distributedTraceContextManager, int statusCode, Logger logger) {
        try {
            if (distributedTraceContextManager != null) {
                if (statusCode >= 400) {
                    distributedTraceContextManager.addCurrentSpanAttribute(SPAN_STATUS, ERROR_STATUS);
                } else {
                    distributedTraceContextManager.addCurrentSpanAttribute(SPAN_STATUS, UNSET_STATUS);
                }
            }
        }
        catch (Throwable e) {
            logger.warn("An exception on updating the client span status", e);
        }
    }
}

