/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.api;

import java.util.Objects;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.runtime.api.util.MultiMap;

public class HttpResponseAttributesBuilder {
    private MultiMap<String, String> headers = MultiMap.emptyMultiMap();
    private int statusCode;
    private String reasonPhrase;

    public HttpResponseAttributesBuilder() {
    }

    public HttpResponseAttributesBuilder(HttpResponseAttributes attributes) {
        this.headers = attributes.getHeaders();
        this.statusCode = attributes.getStatusCode();
        this.reasonPhrase = attributes.getReasonPhrase();
    }

    public HttpResponseAttributesBuilder headers(MultiMap<String, String> headers) {
        Objects.requireNonNull(headers, "HTTP headers cannot be null.");
        this.headers = headers;
        return this;
    }

    public HttpResponseAttributesBuilder statusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public HttpResponseAttributesBuilder reasonPhrase(String reasonPhrase) {
        this.reasonPhrase = reasonPhrase;
        return this;
    }

    public HttpResponseAttributes build() {
        return new HttpResponseAttributes(this.statusCode, this.reasonPhrase, this.headers);
    }
}

