/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.api.certificate;

import java.io.Serializable;
import java.math.BigInteger;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mule.extension.http.api.certificate.AlternativeNameData;
import org.mule.extension.http.api.certificate.CertificateExtension;
import org.mule.extension.http.api.certificate.PrincipalData;
import org.mule.extension.http.api.certificate.PublicKeyData;
import org.mule.extension.http.api.certificate.SerialNumberData;
import org.mule.extension.http.api.certificate.X500PrincipalData;

public class CertificateData
implements Serializable {
    private static final long serialVersionUID = -1585440601605666277L;
    private String type;
    private byte[] encoded;
    private int version;
    private PrincipalData subjectDN;
    private PrincipalData issuerDN;
    private BigInteger serialNumber;
    private Date notBefore;
    private Date notAfter;
    private PublicKeyData publicKey;
    private String sigAlgName;
    private String sigAlgOID;
    private byte[] sigAlgParams;
    private byte[] signature;
    private int basicConstraints;
    private List<String> extendedKeyUsage;
    private boolean[] keyUsage;
    private boolean[] issuerUniqueID;
    private List<AlternativeNameData> subjectAlternativeNames;
    private List<AlternativeNameData> issuerAlternativeNames;
    private List<CertificateExtension> extensions;
    private Set<String> criticalOids = new HashSet<String>();
    private Set<String> nonCriticalOids = new HashSet<String>();
    private boolean hasUnsupportedCriticalExtensions;

    public CertificateData(String type, byte[] encoded) {
        this.type = type;
        this.encoded = encoded;
    }

    public CertificateData(String type, byte[] encoded, int version, PrincipalData subjectDN, PrincipalData issuerDN, BigInteger serialNumber, Date notBefore, Date notAfter, PublicKeyData publicKey, String sigAlgName, String sigAlgOID, byte[] sigAlgParams, byte[] signature, int basicConstraints, List<String> extendedKeyUsage, boolean[] keyUsage, boolean[] issuerUniqueID, List<AlternativeNameData> subjectAlternativeNames, List<AlternativeNameData> issuerAlternativeNames, List<CertificateExtension> extensions, Set<String> criticalOids, Set<String> nonCriticalOids, boolean hasUnsupportedCriticalExtensions) {
        this.type = type;
        this.encoded = encoded;
        this.version = version;
        this.subjectDN = subjectDN;
        this.issuerDN = issuerDN;
        this.serialNumber = serialNumber;
        this.notBefore = notBefore;
        this.notAfter = notAfter;
        this.publicKey = publicKey;
        this.sigAlgName = sigAlgName;
        this.sigAlgOID = sigAlgOID;
        this.sigAlgParams = sigAlgParams;
        this.signature = signature;
        this.basicConstraints = basicConstraints;
        this.extendedKeyUsage = extendedKeyUsage;
        this.keyUsage = keyUsage;
        this.issuerUniqueID = issuerUniqueID;
        this.subjectAlternativeNames = subjectAlternativeNames;
        this.issuerAlternativeNames = issuerAlternativeNames;
        this.extensions = extensions;
        this.criticalOids = criticalOids;
        this.nonCriticalOids = nonCriticalOids;
        this.hasUnsupportedCriticalExtensions = hasUnsupportedCriticalExtensions;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.getSubjectDN().getName();
    }

    public int getVersion() {
        return this.version;
    }

    public PrincipalData getSubjectDN() {
        return this.subjectDN;
    }

    public PrincipalData getIssuerDN() {
        return this.issuerDN;
    }

    public X500PrincipalData getSubjectX500Principal() {
        return new X500PrincipalData(this.subjectDN);
    }

    public X500PrincipalData getIssuerX500Principal() {
        return new X500PrincipalData(this.issuerDN);
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public SerialNumberData getSerialNumberObject() {
        return new SerialNumberData(this.serialNumber);
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public Date getNotAfter() {
        return this.notAfter;
    }

    public PublicKeyData getPublicKey() {
        return this.publicKey;
    }

    public String getSigAlgName() {
        return this.sigAlgName;
    }

    public String getSigAlgOID() {
        return this.sigAlgOID;
    }

    public byte[] getSigAlgParams() {
        return this.sigAlgParams;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public int getBasicConstraints() {
        return this.basicConstraints;
    }

    public List<String> getExtendedKeyUsage() {
        return this.extendedKeyUsage;
    }

    public boolean[] getKeyUsage() {
        return this.keyUsage;
    }

    public List<AlternativeNameData> getSubjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public List<AlternativeNameData> getIssuerAlternativeNames() {
        return this.issuerAlternativeNames;
    }

    public List<CertificateExtension> getExtensions() {
        return this.extensions;
    }

    public byte[] getExtensionValue(String oid) {
        for (CertificateExtension ext : this.extensions) {
            if (!ext.getOid().equals(oid)) continue;
            return ext.getValue();
        }
        throw new IllegalArgumentException("Extension with OID " + oid + " not found");
    }

    public Set<String> getCriticalExtensionOIDs() {
        return new HashSet<String>(this.criticalOids);
    }

    public Set<String> getNonCriticalExtensionOIDs() {
        return new HashSet<String>(this.nonCriticalOids);
    }

    public boolean hasUnsupportedCriticalExtension() {
        return this.hasUnsupportedCriticalExtensions;
    }

    public boolean[] getIssuerUniqueID() {
        return this.issuerUniqueID;
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        Date now = new Date();
        this.checkValidity(now);
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (date.before(this.notBefore)) {
            throw new CertificateNotYetValidException("Certificate is not valid yet: " + date);
        }
        if (date.after(this.notAfter)) {
            throw new CertificateExpiredException("Certificate has expired: " + date);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CertificateData)) {
            return false;
        }
        try {
            byte[] thisCert = this.getEncoded();
            byte[] otherCert = ((CertificateData)other).getEncoded();
            return Arrays.equals(thisCert, otherCert);
        }
        catch (CertificateException e) {
            return false;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[\n[\n  Version: V").append(this.version).append("\n");
        sb.append("  Subject: ").append(this.subjectDN.toString()).append("\n");
        sb.append("  Signature Algorithm: ").append(this.sigAlgName).append(", OID = ").append(this.sigAlgOID).append("\n\n");
        sb.append("  Key:  ").append(this.publicKey.toString().replaceAll("\n", "\n")).append("\n");
        sb.append("  Validity: [From: ").append(this.notBefore).append(",\n");
        sb.append("               To: ").append(this.notAfter).append("]\n");
        sb.append("  Issuer: ").append(this.issuerDN.toString()).append("\n");
        sb.append("  SerialNumber: [    ").append(this.serialNumber.toString(16)).append("]\n\n");
        if (!this.extensions.isEmpty()) {
            sb.append("Certificate Extensions: ").append(this.extensions.size()).append("\n");
            for (int i = 0; i < this.extensions.size(); ++i) {
                CertificateExtension ext = this.extensions.get(i);
                sb.append("[").append(i + 1).append("]: ");
                sb.append(ext.toString()).append("\n");
            }
        } else {
            sb.append("  Certificate Extensions: 0\n");
        }
        sb.append("  Algorithm: [").append(this.sigAlgName).append("]\n");
        sb.append("  Signature:\n").append(CertificateData.formatSignature(this.signature)).append("\n");
        sb.append("]");
        return sb.toString();
    }

    public static String formatSignature(byte[] signature) {
        StringBuilder sb = new StringBuilder();
        StringBuilder asciiPart = new StringBuilder();
        for (int i = 0; i < signature.length; ++i) {
            if (i % 16 == 0) {
                if (i != 0) {
                    sb.append(" ").append((CharSequence)asciiPart).append("\n");
                    asciiPart.setLength(0);
                }
                sb.append(String.format("%04X: ", i));
            }
            sb.append(String.format("%02X ", signature[i]));
            if (signature[i] >= 32 && signature[i] < 125) {
                asciiPart.append((char)signature[i]);
            } else {
                asciiPart.append('.');
            }
            if ((i + 1) % 8 != 0 || (i + 1) % 16 == 0) continue;
            sb.append("  ");
        }
        int remainingBytes = signature.length % 16;
        if (remainingBytes != 0) {
            int padding = (16 - remainingBytes) * 3;
            if (remainingBytes <= 8) {
                ++padding;
            }
            sb.append(CertificateData.repeatSpace(padding)).append(" ").append((CharSequence)asciiPart);
        } else {
            sb.append(" ").append((CharSequence)asciiPart);
        }
        sb.append("\n");
        return sb.toString();
    }

    private static String repeatSpace(int count) {
        char[] chars = new char[count];
        Arrays.fill(chars, ' ');
        return new String(chars);
    }

    /*
     * Exception decompiling
     */
    public byte[] getEncoded() throws CertificateEncodingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

