/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.api.certificate;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PrincipalData
implements Serializable {
    private String name;

    public PrincipalData(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getCommonName() {
        try {
            String subjectDN = this.name;
            Pattern pattern = Pattern.compile("CN=([^,]*)");
            Matcher matcher = pattern.matcher(subjectDN);
            if (matcher.find()) {
                return matcher.group(1);
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PrincipalData that = (PrincipalData)obj;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

