/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.api.error;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;

public enum HttpError implements ErrorTypeDefinition<HttpError>
{
    PARSING,
    TIMEOUT,
    SECURITY((ErrorTypeDefinition<?>)MuleErrors.SECURITY),
    CLIENT_SECURITY((ErrorTypeDefinition<?>)MuleErrors.CLIENT_SECURITY),
    SERVER_SECURITY((ErrorTypeDefinition<?>)MuleErrors.SERVER_SECURITY),
    TRANSFORMATION((ErrorTypeDefinition<?>)MuleErrors.TRANSFORMATION),
    CONNECTIVITY((ErrorTypeDefinition<?>)MuleErrors.CONNECTIVITY),
    BAD_REQUEST,
    BASIC_AUTHENTICATION(SERVER_SECURITY),
    UNAUTHORIZED(CLIENT_SECURITY),
    FORBIDDEN(CLIENT_SECURITY),
    NOT_FOUND,
    METHOD_NOT_ALLOWED,
    NOT_ACCEPTABLE,
    UNSUPPORTED_MEDIA_TYPE(request -> "media type " + request.getHeaderValue("Content-Type") + " not supported"),
    TOO_MANY_REQUESTS,
    INTERNAL_SERVER_ERROR,
    SERVICE_UNAVAILABLE,
    BAD_GATEWAY,
    GATEWAY_TIMEOUT,
    MULTIPLE_CHOICES,
    MOVED_PERMANENTLY,
    MOVED_TEMPORARILY,
    SEE_OTHER,
    NOT_MODIFIED;

    private static Set<ErrorTypeDefinition> httpRequestOperationErrors;
    private ErrorTypeDefinition<?> parentErrorType;
    private Function<HttpRequest, String> errorMessageFunction;

    private HttpError() {
        String message = this.name().replace("_", " ").toLowerCase();
        this.errorMessageFunction = httpRequest -> message;
    }

    private HttpError(ErrorTypeDefinition<?> parentErrorType) {
        this();
        this.parentErrorType = parentErrorType;
    }

    private HttpError(Function<HttpRequest, String> errorMessageFunction) {
        this();
        this.errorMessageFunction = errorMessageFunction;
    }

    private HttpError(ErrorTypeDefinition<?> parentErrorType, Function<HttpRequest, String> errorMessageFunction) {
        this.parentErrorType = parentErrorType;
        this.errorMessageFunction = errorMessageFunction;
    }

    public Optional<ErrorTypeDefinition<? extends Enum<?>>> getParent() {
        return Optional.ofNullable(this.parentErrorType);
    }

    public static Optional<HttpError> getErrorByCode(int statusCode) {
        HttpError error = null;
        HttpConstants.HttpStatus status = HttpConstants.HttpStatus.getStatusByCode((int)statusCode);
        if (status != null) {
            error = Arrays.stream(HttpError.values()).filter(httpError -> httpError.name().equals(status.name())).findFirst().orElse(null);
        }
        return Optional.ofNullable(error);
    }

    public static Optional<HttpConstants.HttpStatus> getHttpStatus(HttpError error) {
        HttpConstants.HttpStatus result = null;
        for (HttpConstants.HttpStatus status : HttpConstants.HttpStatus.values()) {
            if (!error.name().equals(status.name())) continue;
            result = status;
        }
        return Optional.ofNullable(result);
    }

    public static Set<ErrorTypeDefinition> getHttpRequestOperationErrors() {
        return httpRequestOperationErrors;
    }

    public String getErrorMessage(HttpRequest request) {
        return this.errorMessageFunction.apply(request);
    }

    static {
        HashSet<HttpError> errors = new HashSet<HttpError>();
        errors.add(PARSING);
        errors.add(TIMEOUT);
        errors.add(SECURITY);
        errors.add(CLIENT_SECURITY);
        errors.add(CONNECTIVITY);
        errors.add(BAD_REQUEST);
        errors.add(FORBIDDEN);
        errors.add(UNAUTHORIZED);
        errors.add(METHOD_NOT_ALLOWED);
        errors.add(TOO_MANY_REQUESTS);
        errors.add(NOT_FOUND);
        errors.add(UNSUPPORTED_MEDIA_TYPE);
        errors.add(NOT_ACCEPTABLE);
        errors.add(INTERNAL_SERVER_ERROR);
        errors.add(SERVICE_UNAVAILABLE);
        errors.add(BAD_GATEWAY);
        errors.add(GATEWAY_TIMEOUT);
        errors.add(MULTIPLE_CHOICES);
        errors.add(MOVED_PERMANENTLY);
        errors.add(MOVED_TEMPORARILY);
        errors.add(SEE_OTHER);
        errors.add(NOT_MODIFIED);
        httpRequestOperationErrors = Collections.unmodifiableSet(errors);
    }
}

