/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.api.listener.server;

import java.util.Optional;
import org.mule.extension.http.api.listener.headers.HttpHeadersException;
import org.mule.extension.http.api.listener.headers.HttpHeadersValidator;
import org.mule.extension.http.api.listener.headers.InvalidTransferEncodingValidator;
import org.mule.extension.http.api.listener.intercepting.cors.CorsInterceptorWrapper;
import org.mule.extension.http.internal.listener.HttpListener;
import org.mule.extension.http.internal.listener.HttpListenerProvider;
import org.mule.extension.http.internal.listener.ListenerPath;
import org.mule.extension.http.internal.listener.intercepting.HttpListenerInterceptor;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Sources;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;
import org.mule.runtime.extension.api.annotation.param.Parameter;

@Configuration(name="listenerConfig")
@ConnectionProviders(value={HttpListenerProvider.class})
@Sources(value={HttpListener.class})
public class HttpListenerConfig
implements Initialisable {
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private String basePath;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private CorsInterceptorWrapper listenerInterceptors;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private boolean rejectInvalidTransferEncoding;
    private HttpHeadersValidator httpHeaderValidators;

    public void initialise() throws InitialisationException {
        this.basePath = this.sanitizePathWithStartSlash(this.basePath);
        this.httpHeaderValidators = new InvalidTransferEncodingValidator(this.rejectInvalidTransferEncoding);
    }

    public ListenerPath getFullListenerPath(String listenerPath) {
        Preconditions.checkArgument((boolean)listenerPath.startsWith("/"), (String)"listenerPath must start with /");
        return new ListenerPath(this.basePath, listenerPath);
    }

    public String sanitizePathWithStartSlash(String path) {
        if (path == null) {
            return null;
        }
        return path.startsWith("/") ? path : "/" + path;
    }

    public Optional<HttpListenerInterceptor> getInterceptor() {
        return this.listenerInterceptors != null ? Optional.of(this.listenerInterceptors.getInterceptor()) : Optional.empty();
    }

    public void validateHeaders(MultiMap<String, String> headers) throws HttpHeadersException {
        this.httpHeaderValidators.validateHeaders(headers);
    }
}

