/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.api.policy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.policy.api.HttpPolicyPointcutParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpListenerPolicyPointcutParameters
extends HttpPolicyPointcutParameters {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpListenerPolicyPointcutParameters.class);
    private static Method setHeadersMethod;
    private static Method setMaskedRequestPathMethod;

    public HttpListenerPolicyPointcutParameters(Component component, String path, String method) {
        super(component, path, method);
    }

    public HttpListenerPolicyPointcutParameters(Component component, String path, String method, String maskedRequestPath, MultiMap<String, String> headers) {
        super(component, path, method);
        try {
            if (setHeadersMethod != null && setMaskedRequestPathMethod != null) {
                setHeadersMethod.invoke((Object)this, headers);
                setMaskedRequestPathMethod.invoke((Object)this, maskedRequestPath);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Exception while calling setters by reflection"), (Throwable)e);
        }
    }

    static {
        try {
            setHeadersMethod = HttpPolicyPointcutParameters.class.getDeclaredMethod("setHeaders", MultiMap.class);
            setMaskedRequestPathMethod = HttpPolicyPointcutParameters.class.getDeclaredMethod("setMaskedRequestPath", String.class);
        }
        catch (Exception e) {
            LOGGER.debug("setHeaders and setMaskedRequestPath methods are not present in HttpPolicyPointcutParameters class");
        }
    }
}

