/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.api.policy;

import java.util.Map;
import java.util.Objects;
import org.mule.extension.http.api.policy.HttpPolicyRequestAttributes;
import org.mule.runtime.api.util.MultiMap;

public class HttpPolicyRequestAttributesBuilder {
    private MultiMap<String, String> headers = MultiMap.emptyMultiMap();
    private MultiMap<String, String> queryParams = MultiMap.emptyMultiMap();
    private Map<String, String> uriParams = MultiMap.emptyMultiMap();
    private String requestPath;

    public HttpPolicyRequestAttributesBuilder() {
    }

    public HttpPolicyRequestAttributesBuilder(HttpPolicyRequestAttributes attributes) {
        this.headers = attributes.getHeaders();
        this.queryParams = attributes.getQueryParams();
        this.uriParams = attributes.getUriParams();
        this.requestPath = attributes.getRequestPath();
    }

    public HttpPolicyRequestAttributesBuilder headers(MultiMap<String, String> headers) {
        Objects.requireNonNull(headers, "HTTP headers cannot be null.");
        this.headers = headers;
        return this;
    }

    public HttpPolicyRequestAttributesBuilder queryParams(MultiMap<String, String> queryParams) {
        Objects.requireNonNull(queryParams, "HTTP Query params cannot be null.");
        this.queryParams = queryParams;
        return this;
    }

    public HttpPolicyRequestAttributesBuilder uriParams(Map<String, String> uriParams) {
        Objects.requireNonNull(uriParams, "HTTP Uri params cannot be null.");
        this.uriParams = uriParams;
        return this;
    }

    public HttpPolicyRequestAttributesBuilder requestPath(String requestPath) {
        this.requestPath = requestPath;
        return this;
    }

    public HttpPolicyRequestAttributes build() {
        return new HttpPolicyRequestAttributes(this.headers, this.queryParams, this.uriParams, this.requestPath);
    }
}

