/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.api.request.builder;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.mule.extension.http.api.request.builder.TestQueryParam;
import org.mule.extension.http.api.request.builder.TestRequestHeader;
import org.mule.extension.http.api.request.builder.UriParam;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.extension.api.runtime.parameter.Literal;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;

public class HttpRequesterTestRequestBuilder {
    private final Literal<String> requestBody;
    private final List<TestRequestHeader> requestHeaders;
    private final List<TestQueryParam> requestQueryParams;
    private final List<UriParam> requestUriParams;
    private final ExpressionManager expressionManager;
    private final String resolvedRequestBody;

    public HttpRequesterTestRequestBuilder(Literal<String> requestBody, List<TestRequestHeader> requestHeaders, List<TestQueryParam> requestQueryParams, List<UriParam> requestUriParams, ExpressionManager expressionManager) {
        this.requestBody = requestBody;
        this.requestHeaders = requestHeaders;
        this.requestQueryParams = requestQueryParams;
        this.requestUriParams = requestUriParams;
        this.expressionManager = expressionManager;
        this.resolvedRequestBody = this.resolveRequestBody();
    }

    public List<TestRequestHeader> getRequestHeaders() {
        return Collections.unmodifiableList(this.requestHeaders);
    }

    public List<TestQueryParam> getRequestQueryParams() {
        return Collections.unmodifiableList(this.requestQueryParams);
    }

    public List<UriParam> getRequestUriParams() {
        return this.requestUriParams;
    }

    public int hashCode() {
        return Objects.hash(this.requestBody, this.requestHeaders, this.requestQueryParams, this.requestUriParams);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpRequesterTestRequestBuilder that = (HttpRequesterTestRequestBuilder)o;
        return Objects.equals(this.requestBody, that.requestBody) && Objects.equals(this.requestHeaders, that.requestHeaders) && Objects.equals(this.requestQueryParams, that.requestQueryParams) && Objects.equals(this.requestUriParams, that.requestUriParams);
    }

    public HttpEntity buildEntity() {
        if (this.resolvedRequestBody == null || this.resolvedRequestBody.isEmpty()) {
            return new EmptyHttpEntity();
        }
        return new InputStreamHttpEntity((InputStream)new ByteArrayInputStream(this.resolvedRequestBody.getBytes(StandardCharsets.UTF_8)));
    }

    private String resolveRequestBody() {
        if (this.requestBody == null) {
            return null;
        }
        Optional optRequestBody = this.requestBody.getLiteralValue();
        if (!optRequestBody.isPresent()) {
            return null;
        }
        String requestBodyValue = (String)optRequestBody.get();
        if (HttpRequesterTestRequestBuilder.isExpression(requestBodyValue)) {
            return (String)this.expressionManager.evaluate(requestBodyValue, DataType.STRING).getValue();
        }
        return requestBodyValue;
    }

    private static boolean isExpression(String value) {
        String trim = value.trim();
        return trim.startsWith("#[") && trim.endsWith("]");
    }
}

