/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.listener;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.extension.http.api.listener.builder.HttpListenerResponseBuilder;
import org.mule.extension.http.api.streaming.HttpStreamingType;
import org.mule.extension.http.internal.listener.HttpResponseHeaderBuilder;
import org.mule.extension.http.internal.listener.intercepting.Interception;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.Cursor;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponseFactory {
    private static final String HEADER_TRANSFER_ENCODING = "Transfer-Encoding".toLowerCase();
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private HttpStreamingType responseStreaming = HttpStreamingType.AUTO;
    private TransformationService transformationService;
    private Map<Class, TriFunction<TypedValue, Boolean, HttpResponseHeaderBuilder, HttpEntity>> payloadHandlerMapper;
    private Supplier<Boolean> shouldForceConnectionCloseHeader;
    private static final String INVALID_DATA_MSG = "Attempted to send invalid data through http response.";

    public HttpResponseFactory(HttpStreamingType responseStreaming, TransformationService transformationService, Supplier<Boolean> shouldForceConnectionCloseHeader) {
        this.responseStreaming = responseStreaming;
        this.transformationService = transformationService;
        this.payloadHandlerMapper = new HashMap<Class, TriFunction<TypedValue, Boolean, HttpResponseHeaderBuilder, HttpEntity>>();
        this.shouldForceConnectionCloseHeader = shouldForceConnectionCloseHeader;
        this.initResponsePayloadHandlers();
    }

    private void initResponsePayloadHandlers() {
        this.payloadHandlerMapper.put(CursorStreamProvider.class, this::handleCursorStreamProvider);
        this.payloadHandlerMapper.put(InputStream.class, this::handlePayload);
        this.payloadHandlerMapper.put(CursorIteratorProvider.class, this::handleInvalidType);
    }

    private Optional<TriFunction<TypedValue, Boolean, HttpResponseHeaderBuilder, HttpEntity>> getHandler(Class key) {
        for (Class classKey : this.payloadHandlerMapper.keySet()) {
            if (!classKey.isAssignableFrom(key)) continue;
            return Optional.ofNullable(this.payloadHandlerMapper.get(classKey));
        }
        return Optional.empty();
    }

    public HttpResponse create(HttpResponseBuilder responseBuilder, Interception interception, HttpListenerResponseBuilder listenerResponseBuilder, boolean supportsTransferEncoding) {
        String reasonPhrase;
        EmptyHttpEntity httpEntity;
        Object payload;
        HttpResponseHeaderBuilder httpResponseHeaderBuilder = new HttpResponseHeaderBuilder(responseBuilder);
        this.addInterceptingHeaders(interception, httpResponseHeaderBuilder);
        this.addUserHeaders(listenerResponseBuilder, supportsTransferEncoding, httpResponseHeaderBuilder);
        this.addConnectionCloseHeaderIfStopping(httpResponseHeaderBuilder);
        TypedValue<Object> body = listenerResponseBuilder.getBody();
        if (httpResponseHeaderBuilder.getContentType() == null && !MediaType.ANY.matches(body.getDataType().getMediaType())) {
            httpResponseHeaderBuilder.addHeader("Content-Type", body.getDataType().getMediaType().toRfcString());
        }
        if ((payload = body.getValue()) == null) {
            this.setupContentLengthEncoding(httpResponseHeaderBuilder, 0L);
            httpEntity = new EmptyHttpEntity();
        } else {
            httpEntity = this.getHandler(payload.getClass()).map(payloadHandler -> (HttpEntity)payloadHandler.apply(body, supportsTransferEncoding, httpResponseHeaderBuilder)).orElseGet(() -> {
                ByteArrayHttpEntity byteArrayHttpEntity = new ByteArrayHttpEntity(this.getMessageAsBytes(body));
                this.resolveEncoding(httpResponseHeaderBuilder, supportsTransferEncoding, byteArrayHttpEntity);
                return byteArrayHttpEntity;
            });
        }
        Integer statusCode = listenerResponseBuilder.getStatusCode();
        if (statusCode != null) {
            if (statusCode < 200) {
                this.logger.warn(String.format("Response status code '%s' cannot be sent as a final response since it's lower than 200.", statusCode));
                throw new IllegalArgumentException("Cannot send a status code lower than 200");
            }
            responseBuilder.statusCode(statusCode);
            if (statusCode.intValue() == HttpConstants.HttpStatus.NO_CONTENT.getStatusCode() || statusCode.intValue() == HttpConstants.HttpStatus.NOT_MODIFIED.getStatusCode()) {
                httpEntity = new EmptyHttpEntity();
                httpResponseHeaderBuilder.removeHeader(HEADER_TRANSFER_ENCODING);
            }
        }
        if ((reasonPhrase = this.resolveReasonPhrase(listenerResponseBuilder.getReasonPhrase(), statusCode)) != null) {
            responseBuilder.reasonPhrase(reasonPhrase);
        }
        responseBuilder.entity((HttpEntity)httpEntity);
        return responseBuilder.build();
    }

    private void addConnectionCloseHeaderIfStopping(HttpResponseHeaderBuilder httpResponseHeaderBuilder) {
        if (this.shouldForceConnectionCloseHeader.get().booleanValue()) {
            httpResponseHeaderBuilder.removeHeader("Connection");
            httpResponseHeaderBuilder.addHeader("Connection", "close");
        }
    }

    private void addInterceptingHeaders(Interception interception, HttpResponseHeaderBuilder httpResponseHeaderBuilder) {
        MultiMap<String, String> headers = interception.getHeaders();
        headers.keySet().forEach(key -> httpResponseHeaderBuilder.addHeader((String)key, headers.getAll(key)));
    }

    private void addUserHeaders(HttpListenerResponseBuilder listenerResponseBuilder, boolean supportsTransferEncoding, HttpResponseHeaderBuilder httpResponseHeaderBuilder) {
        MultiMap<String, String> headers = listenerResponseBuilder.getHeaders();
        headers.keySet().forEach(key -> {
            if (!supportsTransferEncoding && HEADER_TRANSFER_ENCODING.equalsIgnoreCase((String)key)) {
                this.logger.debug("Client HTTP version is lower than 1.1 so the unsupported 'Transfer-Encoding' header has been removed and 'Content-Length' will be sent instead.");
            } else {
                httpResponseHeaderBuilder.addHeader((String)key, headers.getAll(key));
            }
        });
    }

    private byte[] getMessageAsBytes(TypedValue payload) {
        return (byte[])this.transformationService.transform(Message.builder().payload(payload).build(), DataType.BYTE_ARRAY).getPayload().getValue();
    }

    public String resolveReasonPhrase(String builderReasonPhrase, Integer statusCode) {
        String reasonPhrase = builderReasonPhrase;
        if (reasonPhrase == null && statusCode != null) {
            reasonPhrase = HttpConstants.HttpStatus.getReasonPhraseForStatusCode((int)statusCode);
        }
        return reasonPhrase;
    }

    private HttpEntity guaranteeStreamingIfPossible(boolean possible, HttpResponseHeaderBuilder headerBuilder, Object stream) {
        if (possible) {
            this.setupChunkedEncoding(headerBuilder, "chunked".equals(headerBuilder.getTransferEncoding()));
        }
        return new InputStreamHttpEntity((InputStream)stream);
    }

    private HttpEntity avoidConsumingPayload(HttpResponseHeaderBuilder httpResponseHeaderBuilder, Object payload, Long length) {
        this.setupContentLengthEncoding(httpResponseHeaderBuilder, length);
        return new InputStreamHttpEntity((InputStream)payload, length);
    }

    private HttpEntity consumePayload(HttpResponseHeaderBuilder httpResponseHeaderBuilder, TypedValue stream) {
        ByteArrayHttpEntity byteArrayHttpEntity = new ByteArrayHttpEntity(this.getMessageAsBytes(stream));
        this.setupContentLengthEncoding(httpResponseHeaderBuilder, byteArrayHttpEntity.getBytes().length);
        return byteArrayHttpEntity;
    }

    private void resolveEncoding(HttpResponseHeaderBuilder httpResponseHeaderBuilder, boolean supportsTransferEncoding, ByteArrayHttpEntity byteArrayHttpEntity) {
        boolean chunkedTransferEncoding = "chunked".equals(httpResponseHeaderBuilder.getTransferEncoding());
        if (this.responseStreaming == HttpStreamingType.ALWAYS || chunkedTransferEncoding && this.responseStreaming == HttpStreamingType.AUTO && httpResponseHeaderBuilder.getContentLength() == null) {
            if (supportsTransferEncoding) {
                this.setupChunkedEncoding(httpResponseHeaderBuilder, chunkedTransferEncoding);
            }
        } else {
            this.setupContentLengthEncoding(httpResponseHeaderBuilder, byteArrayHttpEntity.getBytes().length);
        }
    }

    private void setupContentLengthEncoding(HttpResponseHeaderBuilder httpResponseHeaderBuilder, long contentLength) {
        if (httpResponseHeaderBuilder.getTransferEncoding() != null) {
            this.logger.debug("Content-Length encoding is being used so the 'Transfer-Encoding' header has been removed");
            httpResponseHeaderBuilder.removeHeader(HEADER_TRANSFER_ENCODING);
        }
        httpResponseHeaderBuilder.setContentLength(String.valueOf(contentLength));
    }

    private void setupChunkedEncoding(HttpResponseHeaderBuilder httpResponseHeaderBuilder, boolean chunkedTransferEncoding) {
        if (httpResponseHeaderBuilder.getContentLength() != null) {
            this.logger.debug("Chunked encoding is being used so the 'Content-Length' header has been removed");
            httpResponseHeaderBuilder.removeHeader("Content-Length");
        }
        if (!chunkedTransferEncoding) {
            httpResponseHeaderBuilder.addHeader(HEADER_TRANSFER_ENCODING, "chunked");
        }
    }

    public HttpEntity handleCursorStreamProvider(TypedValue body, Boolean supportsTransferEncoding, HttpResponseHeaderBuilder responseHeaderBuilder) {
        Cursor payload = ((CursorStreamProvider)body.getValue()).openCursor();
        return this.handleStreamProvider(responseHeaderBuilder, body, payload, supportsTransferEncoding);
    }

    public HttpEntity handlePayload(TypedValue body, Boolean supportsTransferEncoding, HttpResponseHeaderBuilder responseHeaderBuilder) {
        return this.handleStreamProvider(responseHeaderBuilder, body, body.getValue(), supportsTransferEncoding);
    }

    public HttpEntity handleInvalidType(TypedValue body, Boolean supportsTransferEncoding, HttpResponseHeaderBuilder responseHeaderBuilder) {
        throw new RuntimeException(INVALID_DATA_MSG);
    }

    public HttpEntity handleStreamProvider(HttpResponseHeaderBuilder headerBuilder, TypedValue body, Object payload, boolean supportsTransferEncoding) {
        boolean hasLength = body.getLength().isPresent();
        String existingTransferEncoding = headerBuilder.getTransferEncoding();
        String existingContentLength = headerBuilder.getContentLength();
        HttpEntity httpEntity = this.responseStreaming == HttpStreamingType.ALWAYS ? this.guaranteeStreamingIfPossible(supportsTransferEncoding, headerBuilder, payload) : (this.responseStreaming == HttpStreamingType.AUTO ? (existingContentLength != null ? this.consumePayload(headerBuilder, body) : ("chunked".equals(existingTransferEncoding) || !hasLength ? this.guaranteeStreamingIfPossible(supportsTransferEncoding, headerBuilder, payload) : this.avoidConsumingPayload(headerBuilder, payload, body.getByteLength().getAsLong()))) : (hasLength ? this.avoidConsumingPayload(headerBuilder, payload, body.getByteLength().getAsLong()) : this.consumePayload(headerBuilder, body)));
        return httpEntity;
    }

    @FunctionalInterface
    static interface TriFunction<A, B, C, R> {
        public R apply(A var1, B var2, C var3);
    }
}

