/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.policy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Objects;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.extension.http.api.policy.HttpListenerPolicyPointcutParameters;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.policy.PolicyProvider;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.http.api.domain.CaseInsensitiveMultiMap;
import org.mule.runtime.policy.api.PolicyPointcutParameters;
import org.mule.runtime.policy.api.SourcePolicyPointcutParametersFactory;

public class ReflectiveHttpListenerPolicyPointcutParametersFactory
implements SourcePolicyPointcutParametersFactory {
    public static final String SOURCE_POLICY_AWARE_ATTRIBUTES_CLASS_NAME = "org.mule.runtime.http.policy.api.SourcePolicyAwareAttributes";
    private static final String SOURCE_ATTRIBUTE_CLASS_NAME = "org.mule.runtime.http.policy.api.SourcePolicyAwareAttributes$SourceAttribute";
    private static final String ATTRIBUTE_CLASS_NAME = "org.mule.runtime.policy.api.PolicyAwareAttributes$Attribute";
    private static final String SOURCE_POLICY_AWARE_ATTRIBUTES_METHOD_NAME = "sourcePolicyAwareAttributes";
    private static final String GET_HEADERS_METHOD_NAME = "getHeaders";
    private static final String REQUIRES_METHOD_NAME = "requires";
    private static final String VALUE_OF_METHOD_NAME = "valueOf";
    private static final String HEADERS_ATTRIBUTE_ENUM_NAME = "HEADERS";
    private static final String REQUEST_PATH_ATTRIBUTE_ENUM_NAME = "REQUEST_PATH";
    private static Method sourcePolicyAwareAttributesMethod;
    private static Method requiresMethod;
    private static Method getHeadersMethod;
    private static Object requestPathEnum;
    private static Object headersEnum;
    private final PolicyProvider policyProvider;

    public ReflectiveHttpListenerPolicyPointcutParametersFactory(PolicyProvider policyProvider) {
        this.policyProvider = policyProvider;
    }

    public boolean supportsSourceIdentifier(ComponentIdentifier componentIdentifier) {
        throw new UnsupportedOperationException();
    }

    public <T> PolicyPointcutParameters createPolicyPointcutParameters(Component component, TypedValue<T> attributes) {
        Objects.requireNonNull(component, "Cannot create a policy pointcut parameter instance without a component");
        HttpRequestAttributes httpRequestAttributes = this.requireHttpRequestAttributes(attributes);
        Object sourcePolicyAwareAttributes = this.sourcePolicyAwareAttributes();
        boolean requestPathRequired = this.requires(requestPathEnum, sourcePolicyAwareAttributes);
        boolean headersRequired = this.requires(headersEnum, sourcePolicyAwareAttributes);
        if (requestPathRequired || headersRequired) {
            return new HttpListenerPolicyPointcutParameters(component, requestPathRequired ? httpRequestAttributes.getRequestPath() : "", httpRequestAttributes.getMethod(), httpRequestAttributes.getMaskedRequestPath(), headersRequired ? this.getHeaders(httpRequestAttributes, sourcePolicyAwareAttributes) : MultiMap.emptyMultiMap());
        }
        return new HttpListenerPolicyPointcutParameters(component, null, null);
    }

    private MultiMap<String, String> getHeaders(HttpRequestAttributes httpRequestAttributes, Object sourcePolicyAwareAttributes) {
        CaseInsensitiveMultiMap headers = new CaseInsensitiveMultiMap(httpRequestAttributes.getHeaders());
        headers.keySet().retainAll(this.getHeaders(sourcePolicyAwareAttributes));
        return headers;
    }

    private Collection<String> getHeaders(Object sourcePolicyAwareAttributes) {
        return (Collection)ReflectiveHttpListenerPolicyPointcutParametersFactory.invoke(getHeadersMethod, sourcePolicyAwareAttributes, new Object[0]);
    }

    private boolean requires(Object attribute, Object sourcePolicyAwareAttributes) {
        return (Boolean)ReflectiveHttpListenerPolicyPointcutParametersFactory.invoke(requiresMethod, sourcePolicyAwareAttributes, attribute);
    }

    private Object sourcePolicyAwareAttributes() {
        return ReflectiveHttpListenerPolicyPointcutParametersFactory.invoke(sourcePolicyAwareAttributesMethod, this.policyProvider, new Object[0]);
    }

    private <T> HttpRequestAttributes requireHttpRequestAttributes(TypedValue<T> attributes) {
        if (!(attributes.getValue() instanceof HttpRequestAttributes)) {
            throw new IllegalArgumentException(String.format("Cannot create a policy pointcut parameter instance from a message which attributes is not an instance of %s, the current attribute instance type is: %s", HttpRequestAttributes.class.getName(), attributes.getClass().getName()));
        }
        return (HttpRequestAttributes)attributes.getValue();
    }

    private static Object invoke(Method method, Object instance, Object ... args) {
        try {
            return method.invoke(instance, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Exception while calling method by reflection"), (Throwable)e);
        }
    }

    static {
        try {
            Class sourcePolicyAwareAttributesClass = ClassUtils.loadClass((String)SOURCE_POLICY_AWARE_ATTRIBUTES_CLASS_NAME, ReflectiveHttpListenerPolicyPointcutParametersFactory.class);
            Class sourceAttributesClass = ClassUtils.loadClass((String)SOURCE_ATTRIBUTE_CLASS_NAME, ReflectiveHttpListenerPolicyPointcutParametersFactory.class);
            Class attributeClass = ClassUtils.loadClass((String)ATTRIBUTE_CLASS_NAME, ReflectiveHttpListenerPolicyPointcutParametersFactory.class);
            sourcePolicyAwareAttributesMethod = PolicyProvider.class.getDeclaredMethod(SOURCE_POLICY_AWARE_ATTRIBUTES_METHOD_NAME, new Class[0]);
            getHeadersMethod = sourcePolicyAwareAttributesClass.getDeclaredMethod(GET_HEADERS_METHOD_NAME, new Class[0]);
            requiresMethod = sourcePolicyAwareAttributesClass.getDeclaredMethod(REQUIRES_METHOD_NAME, attributeClass);
            Method valueOf = ClassUtils.getMethod((Class)sourceAttributesClass, (String)VALUE_OF_METHOD_NAME, null);
            requestPathEnum = ReflectiveHttpListenerPolicyPointcutParametersFactory.invoke(valueOf, null, REQUEST_PATH_ATTRIBUTE_ENUM_NAME);
            headersEnum = ReflectiveHttpListenerPolicyPointcutParametersFactory.invoke(valueOf, null, HEADERS_ATTRIBUTE_ENUM_NAME);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Exception while trying to load by reflection"), (Throwable)e);
        }
    }
}

