/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request;

import org.mule.extension.http.api.error.HttpErrorMessageGenerator;
import org.mule.extension.http.api.request.builder.HttpRequesterRequestBuilder;
import org.mule.extension.http.internal.request.HttpRequestFactory;
import org.mule.extension.http.internal.request.HttpRequester;
import org.mule.extension.http.internal.request.HttpResponseToResult;
import org.mule.extension.http.internal.request.OffsetCursorProviderWrapper;
import org.mule.extension.http.internal.request.profiling.HttpProfilingServiceAdaptor;
import org.mule.extension.http.internal.request.profiling.HttpRequestResponseProfilingDataProducerAdaptor;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.MuleContext;

public class HttpRequestUtils {
    public static void handleCursor(HttpRequesterRequestBuilder resolvedBuilder) {
        if (resolvedBuilder.getBody().getValue() instanceof CursorStream) {
            CursorStream cursor = (CursorStream)resolvedBuilder.getBody().getValue();
            long position = cursor.getPosition();
            CursorStreamProvider provider = (CursorStreamProvider)cursor.getProvider();
            if (position == 0L) {
                resolvedBuilder.setBody((TypedValue<Object>)new TypedValue((Object)provider, resolvedBuilder.getBody().getDataType(), resolvedBuilder.getBody().getByteLength()));
            } else {
                resolvedBuilder.setBody((TypedValue<Object>)new TypedValue((Object)new OffsetCursorProviderWrapper(provider, position), resolvedBuilder.getBody().getDataType(), resolvedBuilder.getBody().getByteLength()));
            }
        }
    }

    public static HttpRequester createHttpRequester(boolean httpResponseProfilingEnabled, MuleContext muleContext) throws MuleException {
        return new HttpRequester(new HttpRequestFactory(), new HttpResponseToResult(), new HttpErrorMessageGenerator(), HttpRequestUtils.getProfilingDataProducer(httpResponseProfilingEnabled, muleContext));
    }

    private static HttpRequestResponseProfilingDataProducerAdaptor getProfilingDataProducer(boolean httpResponseProfilingEnabled, MuleContext muleContext) throws MuleException {
        if (!httpResponseProfilingEnabled) {
            return null;
        }
        HttpProfilingServiceAdaptor profilingServiceAdaptor = new HttpProfilingServiceAdaptor();
        muleContext.getInjector().inject((Object)profilingServiceAdaptor);
        return profilingServiceAdaptor.getProfilingHttpRequestDataProducer();
    }
}

