/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.request;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.mule.extension.http.internal.request.ShareableHttpClient;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClientConfiguration;

public class HttpRequesterConnectionManager
implements Disposable {
    @Inject
    private HttpService httpService;
    private Map<String, ShareableHttpClient> clients = new HashMap<String, ShareableHttpClient>();

    public HttpRequesterConnectionManager() {
    }

    public HttpRequesterConnectionManager(HttpService httpService) {
        this.httpService = httpService;
    }

    @Deprecated
    public Optional<ShareableHttpClient> lookup(String configName) {
        return Optional.ofNullable(this.clients.get(configName));
    }

    @Deprecated
    public synchronized ShareableHttpClient create(String configName, HttpClientConfiguration clientConfiguration) {
        Preconditions.checkArgument((!this.clients.containsKey(configName) ? 1 : 0) != 0, (String)String.format("There's an HttpClient available for %s already.", configName));
        ShareableHttpClient client = new ShareableHttpClient(this.httpService.getClientFactory().create(clientConfiguration));
        this.clients.put(configName, client);
        return client;
    }

    public synchronized ShareableHttpClient lookupOrCreate(String configName, Supplier<? extends HttpClientConfiguration> configSupplier) {
        return this.clients.computeIfAbsent(configName, name -> new ShareableHttpClient(this.httpService.getClientFactory().create((HttpClientConfiguration)configSupplier.get())));
    }

    public void dispose() {
        this.clients.clear();
    }

    public void disposeClient(String configName) {
        this.clients.remove(configName);
    }
}

