/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.api.error;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;

public enum HttpError implements ErrorTypeDefinition<HttpError>
{
    PARSING,
    TIMEOUT,
    SECURITY((ErrorTypeDefinition<?>)MuleErrors.SECURITY),
    CLIENT_SECURITY((ErrorTypeDefinition<?>)MuleErrors.CLIENT_SECURITY),
    SERVER_SECURITY((ErrorTypeDefinition<?>)MuleErrors.SERVER_SECURITY),
    TRANSFORMATION((ErrorTypeDefinition<?>)MuleErrors.TRANSFORMATION),
    CONNECTIVITY((ErrorTypeDefinition<?>)MuleErrors.CONNECTIVITY),
    BAD_REQUEST,
    BASIC_AUTHENTICATION(SERVER_SECURITY),
    UNAUTHORIZED(CLIENT_SECURITY),
    FORBIDDEN(CLIENT_SECURITY),
    NOT_FOUND,
    METHOD_NOT_ALLOWED,
    NOT_ACCEPTABLE,
    UNSUPPORTED_MEDIA_TYPE(request -> "media type " + request.getHeaderValue("Content-Type") + " not supported"),
    TOO_MANY_REQUESTS,
    INTERNAL_SERVER_ERROR,
    SERVICE_UNAVAILABLE;

    private ErrorTypeDefinition<?> parentErrorType;
    private Function<HttpRequest, String> errorMessageFunction;

    private HttpError() {
        String message = this.name().replace("_", " ").toLowerCase();
        this.errorMessageFunction = httpRequest -> message;
    }

    private HttpError(ErrorTypeDefinition<?> parentErrorType) {
        this();
        this.parentErrorType = parentErrorType;
    }

    private HttpError(Function<HttpRequest, String> errorMessageFunction) {
        this();
        this.errorMessageFunction = errorMessageFunction;
    }

    private HttpError(ErrorTypeDefinition<?> parentErrorType, Function<HttpRequest, String> errorMessageFunction) {
        this.parentErrorType = parentErrorType;
        this.errorMessageFunction = errorMessageFunction;
    }

    public Optional<ErrorTypeDefinition<? extends Enum<?>>> getParent() {
        return Optional.ofNullable(this.parentErrorType);
    }

    public static Optional<HttpError> getErrorByCode(int statusCode) {
        HttpError error = null;
        HttpConstants.HttpStatus status = HttpConstants.HttpStatus.getStatusByCode((int)statusCode);
        if (status != null) {
            try {
                error = HttpError.valueOf(status.name());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Optional.ofNullable(error);
    }

    public static Optional<HttpConstants.HttpStatus> getHttpStatus(HttpError error) {
        HttpConstants.HttpStatus result = null;
        for (HttpConstants.HttpStatus status : HttpConstants.HttpStatus.values()) {
            if (!error.name().equals(status.name())) continue;
            result = status;
        }
        return Optional.ofNullable(result);
    }

    public static Set<ErrorTypeDefinition> getHttpRequestOperationErrors() {
        return ImmutableSet.builder().add((Object)PARSING).add((Object)TIMEOUT).add((Object)SECURITY).add((Object)CLIENT_SECURITY).add((Object)CONNECTIVITY).add((Object)BAD_REQUEST).add((Object)FORBIDDEN).add((Object)UNAUTHORIZED).add((Object)METHOD_NOT_ALLOWED).add((Object)TOO_MANY_REQUESTS).add((Object)NOT_FOUND).add((Object)UNSUPPORTED_MEDIA_TYPE).add((Object)NOT_ACCEPTABLE).add((Object)INTERNAL_SERVER_ERROR).add((Object)SERVICE_UNAVAILABLE).build();
    }

    public String getErrorMessage(HttpRequest request) {
        return this.errorMessageFunction.apply(request);
    }
}

