/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.api.listener;

import java.util.Base64;
import java.util.List;
import org.mule.extension.http.api.HttpListenerResponseAttributes;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.extension.http.internal.filter.BasicUnauthorisedException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.security.Credentials;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.api.security.SecurityProviderNotFoundException;
import org.mule.runtime.api.security.UnauthorisedException;
import org.mule.runtime.api.security.UnknownAuthenticationTypeException;
import org.mule.runtime.api.security.UnsupportedAuthenticationSchemeException;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.security.AuthenticationHandler;
import org.mule.runtime.http.api.HttpConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpBasicAuthenticationFilter {
    private static final String HEADER_AUTHORIZATION = "Authorization".toLowerCase();
    private static final char PADDING = '=';
    private static final Base64.Decoder DECODER = Base64.getDecoder();
    private static boolean LAX_DECODING = Boolean.getBoolean("mule.http.basic.laxBase64Decoding");
    protected static final Logger logger = LoggerFactory.getLogger(HttpBasicAuthenticationFilter.class);
    @Parameter
    private String realm;
    @Parameter
    @Optional
    @NullSafe
    private List<String> securityProviders;
    @Parameter
    @Optional(defaultValue="#[attributes]")
    HttpRequestAttributes attributes;

    public void authenticate(AuthenticationHandler authenticationHandler) throws SecurityException, SecurityProviderNotFoundException, UnknownAuthenticationTypeException {
        String header = (String)this.attributes.getHeaders().get((Object)HEADER_AUTHORIZATION);
        if (logger.isDebugEnabled()) {
            logger.debug("Authorization header: " + header);
        }
        if (header != null && header.startsWith("Basic ")) {
            String token;
            String base64Token = header.substring(6);
            if (LAX_DECODING) {
                base64Token = base64Token.substring(0, base64Token.lastIndexOf(61) + 1);
            }
            try {
                token = new String(DECODER.decode(base64Token.getBytes()));
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Authentication request failed: " + e.toString());
                }
                throw new BasicUnauthorisedException(I18nMessageFactory.createStaticMessage((String)"Could not decode authorization header."), e, this.createUnauthenticatedMessage());
            }
            String username = "";
            String password = "";
            int delim = token.indexOf(":");
            if (delim != -1) {
                username = token.substring(0, delim);
                password = token.substring(delim + 1);
            }
            Credentials credentials = authenticationHandler.createCredentialsBuilder().withUsername(username).withPassword(password.toCharArray()).build();
            try {
                authenticationHandler.setAuthentication(this.securityProviders, authenticationHandler.createAuthentication(credentials));
            }
            catch (UnauthorisedException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Authentication request for user: " + username + " failed: " + e.toString());
                }
                throw new BasicUnauthorisedException(CoreMessages.authFailedForUser((Object)username), e, this.createUnauthenticatedMessage());
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Authentication success.");
            }
        } else {
            if (header == null) {
                throw new BasicUnauthorisedException(null, "HTTP basic authentication", "HTTP listener", this.createUnauthenticatedMessage());
            }
            throw new UnsupportedAuthenticationSchemeException(I18nMessageFactory.createStaticMessage((String)("Http Basic filter doesn't know how to handle header " + header)), this.createUnauthenticatedMessage());
        }
    }

    private Message createUnauthenticatedMessage() {
        String realmHeader = "Basic realm=";
        if (this.realm != null) {
            realmHeader = realmHeader + "\"" + this.realm + "\"";
        }
        MultiMap headers = new MultiMap();
        headers.put((Object)"WWW-Authenticate", (Object)realmHeader);
        return Message.builder().nullValue().attributesValue((Object)new HttpListenerResponseAttributes(HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode(), HttpConstants.HttpStatus.UNAUTHORIZED.getReasonPhrase(), (MultiMap<String, String>)headers)).build();
    }

    public static void refreshSystemProperties() {
        LAX_DECODING = Boolean.getBoolean("mule.http.basic.laxBase64Decoding");
    }
}

