/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.api.policy;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.mule.extension.http.api.BaseHttpRequestAttributes;
import org.mule.extension.http.api.policy.HttpPolicyRequestAttributes;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.policy.OperationPolicyParametersTransformer;

public class HttpPolicyRequestParametersTransformer
implements OperationPolicyParametersTransformer {
    private static final DataType HTTP_POLICY_REQUEST_ATTRIBUTES_DATATYPE = DataType.fromType(HttpPolicyRequestAttributes.class);
    private static final String BODY = "body";
    private static final String PATH = "path";
    private static final String HEADERS = "headers";
    private static final String QUERY_PARAMS = "queryParams";
    private static final String URI_PARAMS = "uriParams";

    public boolean supports(ComponentIdentifier componentIdentifier) {
        return componentIdentifier.equals(ComponentIdentifier.buildFromStringRepresentation((String)"http:request"));
    }

    public Message fromParametersToMessage(Map<String, Object> parameters) {
        TypedValue body = (TypedValue)parameters.getOrDefault(BODY, new TypedValue(null, DataType.OBJECT));
        return Message.builder().payload(body).attributes(new TypedValue((Object)new HttpPolicyRequestAttributes(this.getMultiMap(parameters, HEADERS), this.getMultiMap(parameters, QUERY_PARAMS), this.getMap(parameters, URI_PARAMS), (String)parameters.get(PATH)), HTTP_POLICY_REQUEST_ATTRIBUTES_DATATYPE)).build();
    }

    public Map<String, Object> fromMessageToParameters(Message message) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (message.getAttributes().getValue() instanceof BaseHttpRequestAttributes) {
            BaseHttpRequestAttributes requestAttributes = (BaseHttpRequestAttributes)message.getAttributes().getValue();
            this.putIfNotNull((ImmutableMap.Builder<String, Object>)builder, PATH, requestAttributes.getRequestPath());
            this.putIfNotNull((ImmutableMap.Builder<String, Object>)builder, HEADERS, requestAttributes.getHeaders());
            this.putIfNotNull((ImmutableMap.Builder<String, Object>)builder, QUERY_PARAMS, requestAttributes.getQueryParams());
            this.putIfNotNull((ImmutableMap.Builder<String, Object>)builder, URI_PARAMS, requestAttributes.getUriParams());
        }
        this.putIfNotNull((ImmutableMap.Builder<String, Object>)builder, BODY, message.getPayload());
        return builder.build();
    }

    private void putIfNotNull(ImmutableMap.Builder<String, Object> builder, String key, Object value) {
        if (value != null) {
            builder.put((Object)key, value);
        }
    }

    private MultiMap<String, String> getMultiMap(Map<String, Object> parameters, String key) {
        return (MultiMap)parameters.getOrDefault(key, MultiMap.emptyMultiMap());
    }

    private Map<String, String> getMap(Map<String, Object> parameters, String key) {
        return (Map)parameters.getOrDefault(key, MultiMap.emptyMultiMap());
    }
}

