/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.certificate;

import java.security.cert.Certificate;
import java.util.function.Supplier;
import org.mule.extension.http.internal.certificate.CertificateProvider;
import org.mule.extension.http.internal.certificate.CompatibilityCertificateProvider;
import org.mule.extension.http.internal.certificate.DefaultCertificateProvider;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.util.ClassUtils;

public class CertificateProviderFactory {
    private static boolean isSerializableLazyValuePresent = ClassUtils.isClassOnPath((String)"org.mule.runtime.api.util.SerializableLazyValue", CertificateProvider.class);

    public static CertificateProvider create(Supplier<Certificate> certificateSupplier) {
        if (isSerializableLazyValuePresent) {
            try {
                return new DefaultCertificateProvider(certificateSupplier);
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Errors while creating org.mule.runtime.api.util.SerializableLazyValue by reflection, even when class in on classpath."), (Throwable)e);
            }
        }
        return new CompatibilityCertificateProvider(certificateSupplier);
    }
}

