/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.listener;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringEscapeUtils;
import org.mule.extension.http.api.HttpListenerResponseAttributes;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.extension.http.api.error.HttpError;
import org.mule.extension.http.api.listener.builder.HttpListenerErrorResponseBuilder;
import org.mule.extension.http.api.listener.builder.HttpListenerSuccessResponseBuilder;
import org.mule.extension.http.api.listener.server.HttpListenerConfig;
import org.mule.extension.http.api.streaming.HttpStreamingType;
import org.mule.extension.http.internal.HttpMetadataResolver;
import org.mule.extension.http.internal.listener.HttpListenerResponseSender;
import org.mule.extension.http.internal.listener.HttpRequestToResult;
import org.mule.extension.http.internal.listener.HttpResponseContext;
import org.mule.extension.http.internal.listener.HttpResponseFactory;
import org.mule.extension.http.internal.listener.ListenerPath;
import org.mule.extension.http.internal.listener.intercepting.InterceptingException;
import org.mule.extension.http.internal.listener.server.ModuleRequestHandler;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.exception.DisjunctiveErrorTypeMatcher;
import org.mule.runtime.core.api.exception.ErrorTypeMatcher;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.core.api.exception.SingleErrorTypeMatcher;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.SystemUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Streaming;
import org.mule.runtime.extension.api.annotation.execution.OnError;
import org.mule.runtime.extension.api.annotation.execution.OnSuccess;
import org.mule.runtime.extension.api.annotation.execution.OnTerminate;
import org.mule.runtime.extension.api.annotation.metadata.MetadataScope;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.source.BackPressure;
import org.mule.runtime.extension.api.annotation.source.EmitsResponse;
import org.mule.runtime.extension.api.annotation.source.OnBackPressure;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.BackPressureContext;
import org.mule.runtime.extension.api.runtime.source.BackPressureMode;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.runtime.extension.api.runtime.source.SourceCompletionCallback;
import org.mule.runtime.extension.api.runtime.source.SourceResult;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.HttpProtocol;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.RequestHandlerManager;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="listener")
@EmitsResponse
@Streaming
@MediaType(value="*/*", strict=false)
@BackPressure(defaultMode=BackPressureMode.FAIL, supportedModes={BackPressureMode.FAIL})
@MetadataScope(outputResolver=HttpMetadataResolver.class)
public class HttpListener
extends Source<InputStream, HttpRequestAttributes> {
    private static final String RESPONSE_SEND_ATTEMPT = "responseSendAttempt";
    public static final String HTTP_NAMESPACE = "http";
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpListener.class);
    private static final String SERVER_PROBLEM = "Server encountered a problem";
    private static final String RESPONSE_CONTEXT = "responseContext";
    private static final String RESPONSE_CONTEXT_NOT_FOUND = "Response Context is not present. Could not send response.";
    private static final String HEADER_X_CORRELATION_ID = "X-Correlation-ID".toLowerCase();
    private static final String HEADER_MULE_CORRELATION_ID = "MULE_CORRELATION_ID".toLowerCase();
    private static final String REPEATED_HEADERS_LOG_FORMAT = "'X-Correlation-ID: {}' and 'MULE_CORRELATION_ID: {}' headers found. 'X-Correlation-ID' will be used.";
    @Inject
    private TransformationService transformationService;
    @Inject
    private MuleContext muleContext;
    @Config
    private HttpListenerConfig config;
    @Connection
    private ConnectionProvider<HttpServer> serverProvider;
    @Parameter
    @Placement(order=1)
    private String path;
    @Parameter
    @Optional
    @Placement(tab="Advanced")
    @Summary(value="Comma separated list of methods. Leave empty to allow all.")
    @Example(value="GET, POST")
    private String allowedMethods;
    @Parameter
    @Optional(defaultValue="AUTO")
    @Placement(tab="Advanced")
    private HttpStreamingType responseStreamingMode;
    private HttpServer server;
    private HttpListenerResponseSender responseSender;
    private ListenerPath listenerPath;
    private RequestHandlerManager requestHandlerManager;
    private HttpResponseFactory responseFactory;
    private ErrorTypeMatcher knownErrors;
    private Class interpretedAttributes;

    @OnSuccess
    public void onSuccess(@ParameterGroup(name="Response", showInDsl=true) HttpListenerSuccessResponseBuilder response, SourceCallbackContext callbackContext, SourceCompletionCallback completionCallback) throws Exception {
        HttpResponseContext context = (HttpResponseContext)callbackContext.getVariable(RESPONSE_CONTEXT).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)RESPONSE_CONTEXT_NOT_FOUND)));
        this.responseSender.sendResponse(context, response, completionCallback);
    }

    @OnError
    public void onError(@ParameterGroup(name="Error Response", showInDsl=true) HttpListenerErrorResponseBuilder errorResponse, SourceCallbackContext callbackContext, Error error, SourceCompletionCallback completionCallback) {
        try {
            this.sendErrorResponse(errorResponse, callbackContext, error, completionCallback);
        }
        catch (Throwable t) {
            completionCallback.error(t);
        }
    }

    @OnBackPressure
    public void onBackPressure(BackPressureContext ctx, SourceCompletionCallback completionCallback) {
        try {
            this.sendBackPressureResponse(ctx, completionCallback);
        }
        catch (Throwable t) {
            completionCallback.error(t);
        }
    }

    @OnTerminate
    public void onTerminate(SourceResult sourceResult) {
        Boolean sendingResponse = sourceResult.getSourceCallbackContext().getVariable(RESPONSE_SEND_ATTEMPT).orElse(false);
        if (Boolean.FALSE.equals(sendingResponse)) {
            sourceResult.getInvocationError().ifPresent(error -> this.sendErrorResponse(new HttpListenerErrorResponseBuilder(), sourceResult.getSourceCallbackContext(), (Error)error, null));
        }
    }

    private void sendErrorResponse(HttpListenerErrorResponseBuilder errorResponse, SourceCallbackContext callbackContext, Error error, SourceCompletionCallback completionCallback) {
        HttpResponse response;
        HttpResponseBuilder failureResponseBuilder = this.createFailureResponseBuilder(error);
        if (errorResponse.getBody() == null || errorResponse.getBody().getValue() == null) {
            errorResponse.setBody((TypedValue<Object>)new TypedValue((Object)error.getDescription(), DataType.STRING));
        }
        HttpResponseContext context = (HttpResponseContext)callbackContext.getVariable(RESPONSE_CONTEXT).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)RESPONSE_CONTEXT_NOT_FOUND)));
        try {
            response = this.responseFactory.create(failureResponseBuilder, context.getInterception(), errorResponse, context.isSupportStreaming());
        }
        catch (Exception e) {
            response = this.buildErrorResponse();
        }
        HttpResponseReadyCallback responseCallback = context.getResponseCallback();
        callbackContext.addVariable(RESPONSE_SEND_ATTEMPT, (Object)true);
        responseCallback.responseReady(response, this.getResponseFailureCallback(responseCallback, completionCallback));
    }

    private void sendBackPressureResponse(BackPressureContext ctx, SourceCompletionCallback completionCallback) {
        HttpResponse response;
        SourceCallbackContext callbackContext = ctx.getSourceCallbackContext();
        HttpResponseContext context = (HttpResponseContext)callbackContext.getVariable(RESPONSE_CONTEXT).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)RESPONSE_CONTEXT_NOT_FOUND)));
        HttpResponseBuilder responseBuilder = HttpResponse.builder().statusCode(Integer.valueOf(HttpConstants.HttpStatus.SERVICE_UNAVAILABLE.getStatusCode()));
        HttpListenerErrorResponseBuilder errorResponseBuilder = new HttpListenerErrorResponseBuilder();
        errorResponseBuilder.setBody((TypedValue<Object>)new TypedValue(null, DataType.STRING));
        errorResponseBuilder.setStatusCode(HttpConstants.HttpStatus.SERVICE_UNAVAILABLE.getStatusCode());
        errorResponseBuilder.setReasonPhrase(HttpConstants.HttpStatus.SERVICE_UNAVAILABLE.getReasonPhrase());
        try {
            response = this.responseFactory.create(responseBuilder, context.getInterception(), errorResponseBuilder, context.isSupportStreaming());
        }
        catch (Exception e) {
            response = this.buildErrorResponse();
        }
        HttpResponseReadyCallback responseCallback = context.getResponseCallback();
        callbackContext.addVariable(RESPONSE_SEND_ATTEMPT, (Object)true);
        responseCallback.responseReady(response, this.getResponseFailureCallback(responseCallback, completionCallback));
    }

    private HttpResponseBuilder createFailureResponseBuilder(Error error) {
        HttpResponseBuilder failureResponseBuilder;
        if (this.hasCustomResponse(java.util.Optional.ofNullable(error))) {
            Message errorMessage = error.getErrorMessage();
            HttpResponseAttributes attributes = (HttpResponseAttributes)errorMessage.getAttributes().getValue();
            failureResponseBuilder = HttpResponse.builder().statusCode(Integer.valueOf(attributes.getStatusCode())).reasonPhrase(attributes.getReasonPhrase());
            attributes.getHeaders().forEach((arg_0, arg_1) -> ((HttpResponseBuilder)failureResponseBuilder).addHeader(arg_0, arg_1));
        } else {
            failureResponseBuilder = error != null ? this.createDefaultFailureResponseBuilder(error, HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR) : HttpResponse.builder();
        }
        return failureResponseBuilder;
    }

    public void onStart(SourceCallback<InputStream, HttpRequestAttributes> sourceCallback) throws MuleException {
        this.server = (HttpServer)this.serverProvider.connect();
        this.listenerPath = this.config.getFullListenerPath(this.config.sanitizePathWithStartSlash(this.path));
        this.path = this.listenerPath.getResolvedPath();
        this.responseFactory = new HttpResponseFactory(this.responseStreamingMode, this.transformationService);
        this.responseSender = new HttpListenerResponseSender(this.responseFactory);
        LifecycleUtils.startIfNeeded((Object)this.responseFactory);
        this.validatePath();
        this.interpretedAttributes = HttpListenerResponseAttributes.class;
        try {
            this.requestHandlerManager = this.allowedMethods != null ? this.server.addRequestHandler(Arrays.asList(this.extractAllowedMethods()), this.path, this.getRequestHandler(sourceCallback)) : this.server.addRequestHandler(this.path, this.getRequestHandler(sourceCallback));
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        this.knownErrors = new DisjunctiveErrorTypeMatcher(this.createErrorMatcherList(this.muleContext.getErrorTypeRepository()));
        this.requestHandlerManager.start();
    }

    private List<ErrorTypeMatcher> createErrorMatcherList(ErrorTypeRepository errorTypeRepository) {
        LinkedList<ErrorTypeMatcher> matchers = new LinkedList<ErrorTypeMatcher>();
        matchers.add((ErrorTypeMatcher)new SingleErrorTypeMatcher((ErrorType)errorTypeRepository.lookupErrorType(Errors.ComponentIdentifiers.Handleable.SECURITY).get()));
        ComponentIdentifier.Builder httpErrorBuilder = ComponentIdentifier.builder().namespace(HTTP_NAMESPACE.toUpperCase());
        matchers.add((ErrorTypeMatcher)new SingleErrorTypeMatcher((ErrorType)errorTypeRepository.lookupErrorType(httpErrorBuilder.name(HttpError.NOT_FOUND.name()).build()).get()));
        matchers.add((ErrorTypeMatcher)new SingleErrorTypeMatcher((ErrorType)errorTypeRepository.lookupErrorType(httpErrorBuilder.name(HttpError.BASIC_AUTHENTICATION.name()).build()).get()));
        return matchers;
    }

    public void onStop() {
        if (this.requestHandlerManager != null) {
            this.requestHandlerManager.stop();
            this.requestHandlerManager.dispose();
        }
        if (this.server != null) {
            this.serverProvider.disconnect((Object)this.server);
        }
    }

    private RequestHandler getRequestHandler(final SourceCallback<InputStream, HttpRequestAttributes> sourceCallback) {
        final ClassLoader appRegionClassLoader = Thread.currentThread().getContextClassLoader();
        return new ModuleRequestHandler(){

            @Override
            public Result<InputStream, HttpRequestAttributes> createResult(HttpRequestContext requestContext) {
                return HttpListener.this.createResult(requestContext);
            }

            public void handleRequest(HttpRequestContext requestContext, HttpResponseReadyCallback responseCallback) {
                try {
                    Result<InputStream, HttpRequestAttributes> result = this.createResult(requestContext);
                    HttpResponseContext responseContext = new HttpResponseContext();
                    String httpVersion = requestContext.getRequest().getProtocol().asString();
                    responseContext.setHttpVersion(httpVersion);
                    responseContext.setSupportStreaming(HttpListener.this.supportsTransferEncoding(httpVersion));
                    responseContext.setResponseCallback(responseCallback);
                    MultiMap<String, String> headers = this.getHeaders(result);
                    HttpListener.this.config.getInterceptor().ifPresent(interceptor -> responseContext.setInterception(interceptor.request(this.getMethod(result), headers)));
                    SourceCallbackContext context = sourceCallback.createContext();
                    context.addVariable(HttpListener.RESPONSE_CONTEXT, (Object)responseContext);
                    this.resolveCorrelationId(headers, context);
                    sourceCallback.handle(result, context);
                }
                catch (IllegalArgumentException e) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.warn("Exception occurred parsing request:", (Throwable)e);
                    } else {
                        LOGGER.warn("'{}: {}' occurred processing request", (Object)e.getClass().getName(), (Object)e.getMessage());
                    }
                    this.sendErrorResponse(HttpConstants.HttpStatus.BAD_REQUEST, this.getEscapedErrorBody(e), responseCallback);
                }
                catch (InterceptingException e) {
                    this.sendErrorResponse(e, responseCallback);
                }
                catch (RuntimeException e) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.warn("Exception occurred processing request:", (Throwable)e);
                    } else {
                        LOGGER.warn("'{}: {}' occurred processing request", (Object)e.getClass().getName(), (Object)e.getMessage());
                    }
                    this.sendErrorResponse(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR, HttpListener.SERVER_PROBLEM, responseCallback);
                }
            }

            private String getEscapedErrorBody(Exception e) {
                return String.format("HTTP request parsing failed with error: \"%s\"", StringEscapeUtils.escapeHtml4((String)e.getMessage()));
            }

            private void resolveCorrelationId(MultiMap<String, String> headers, SourceCallbackContext context) {
                String xCorrelationId = (String)headers.get((Object)HEADER_X_CORRELATION_ID);
                String muleCorrelationId = (String)headers.get((Object)HEADER_MULE_CORRELATION_ID);
                if (xCorrelationId != null) {
                    if (muleCorrelationId != null) {
                        if (xCorrelationId.equals(muleCorrelationId)) {
                            LOGGER.debug(HttpListener.REPEATED_HEADERS_LOG_FORMAT, (Object)xCorrelationId, (Object)muleCorrelationId);
                        } else {
                            LOGGER.warn(HttpListener.REPEATED_HEADERS_LOG_FORMAT, (Object)xCorrelationId, (Object)muleCorrelationId);
                        }
                    }
                    context.setCorrelationId(xCorrelationId);
                } else if (muleCorrelationId != null) {
                    context.setCorrelationId(muleCorrelationId);
                }
            }

            private String getMethod(Result<InputStream, HttpRequestAttributes> result) {
                return ((HttpRequestAttributes)result.getAttributes().get()).getMethod();
            }

            private MultiMap<String, String> getHeaders(Result<InputStream, HttpRequestAttributes> result) {
                return ((HttpRequestAttributes)result.getAttributes().get()).getHeaders();
            }

            private void sendErrorResponse(InterceptingException interceptor, HttpResponseReadyCallback responseCallback) {
                final HttpConstants.HttpStatus status = interceptor.status();
                HttpResponseBuilder responseBuilder = HttpResponse.builder().statusCode(Integer.valueOf(status.getStatusCode())).reasonPhrase(status.getReasonPhrase());
                interceptor.headers().entryList().forEach(entry -> {
                    HttpResponseBuilder cfr_ignored_0 = (HttpResponseBuilder)responseBuilder.addHeader((String)entry.getKey(), (String)entry.getValue());
                });
                responseCallback.responseReady(responseBuilder.build(), new ResponseStatusCallback(){

                    public void responseSendFailure(Throwable exception) {
                        this.logError(status, exception);
                    }

                    public void responseSendSuccessfully() {
                    }
                });
            }

            private void sendErrorResponse(final HttpConstants.HttpStatus status, String message, HttpResponseReadyCallback responseCallback) {
                byte[] responseData = message.getBytes();
                responseCallback.responseReady(((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().statusCode(Integer.valueOf(status.getStatusCode())).reasonPhrase(status.getReasonPhrase()).entity((HttpEntity)new ByteArrayHttpEntity(responseData))).addHeader("Content-Length", Integer.toString(responseData.length))).build(), new ResponseStatusCallback(){

                    public void responseSendFailure(Throwable exception) {
                        this.logError(status, exception);
                    }

                    public void responseSendSuccessfully() {
                    }
                });
            }

            private void logError(HttpConstants.HttpStatus status, Throwable exception) {
                LOGGER.warn("Error while sending {} response {}", (Object)status.getStatusCode(), (Object)exception.getMessage());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Exception thrown", exception);
                }
            }

            public ClassLoader getContextClassLoader() {
                return appRegionClassLoader;
            }
        };
    }

    private boolean hasCustomResponse(java.util.Optional<Error> error) {
        return error.isPresent() && this.knownErrors.match(error.get().getErrorType()) && error.get().getErrorMessage() != null && this.interpretedAttributes.isInstance(error.get().getErrorMessage().getAttributes().getValue());
    }

    private HttpResponseBuilder createDefaultFailureResponseBuilder(Error error, HttpConstants.HttpStatus httpStatus) {
        Throwable throwable = error.getCause();
        String reasonPhraseFromException = HttpConstants.HttpStatus.getReasonPhraseForStatusCode((int)httpStatus.getStatusCode());
        return HttpResponse.builder().statusCode(Integer.valueOf(httpStatus.getStatusCode())).reasonPhrase(reasonPhraseFromException != null ? reasonPhraseFromException : throwable.getMessage());
    }

    private Result<InputStream, HttpRequestAttributes> createResult(HttpRequestContext requestContext) {
        return HttpRequestToResult.transform(requestContext, SystemUtils.getDefaultEncoding((MuleContext)this.muleContext), this.listenerPath);
    }

    protected HttpResponse buildErrorResponse() {
        HttpResponseBuilder errorResponseBuilder = HttpResponse.builder();
        HttpResponse errorResponse = errorResponseBuilder.statusCode(Integer.valueOf(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode())).reasonPhrase(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase()).build();
        return errorResponse;
    }

    private ResponseStatusCallback getResponseFailureCallback(final HttpResponseReadyCallback responseReadyCallback, final SourceCompletionCallback completionCallback) {
        return new BaseResponseStatusCallback(completionCallback){

            public void responseSendFailure(Throwable throwable) {
                LOGGER.error("Found exception trying to send response", throwable);
                responseReadyCallback.responseReady(HttpListener.this.buildErrorResponse(), (ResponseStatusCallback)new BaseResponseStatusCallback(completionCallback){

                    public void responseSendFailure(Throwable throwable) {
                        LOGGER.error("Found exception trying to send error response", throwable);
                        if (completionCallback != null) {
                            completionCallback.error(throwable);
                        }
                    }
                });
            }
        };
    }

    private boolean supportsTransferEncoding(String httpVersion) {
        return !HttpProtocol.HTTP_0_9.asString().equals(httpVersion) && !HttpProtocol.HTTP_1_0.asString().equals(httpVersion);
    }

    private String[] extractAllowedMethods() throws InitialisationException {
        String[] values = this.allowedMethods.split(",");
        String[] normalizedValues = new String[values.length];
        int normalizedValueIndex = 0;
        for (String value : values) {
            normalizedValues[normalizedValueIndex] = value.trim().toUpperCase();
            ++normalizedValueIndex;
        }
        return normalizedValues;
    }

    private void validatePath() throws MuleException {
        String[] pathParts = this.path.split("/");
        ArrayList<String> uriParamNames = new ArrayList<String>();
        for (String pathPart : pathParts) {
            if (pathPart.startsWith("{") && pathPart.endsWith("}")) {
                String uriParamName = pathPart.substring(1, pathPart.length() - 1);
                if (uriParamNames.contains(uriParamName)) {
                    throw new DefaultMuleException(I18nMessageFactory.createStaticMessage((String)String.format("Http Listener with path %s contains duplicated uri param names", this.path)));
                }
                uriParamNames.add(uriParamName);
                continue;
            }
            if (!pathPart.contains("*") || pathPart.length() <= 1) continue;
            throw new DefaultMuleException(I18nMessageFactory.createStaticMessage((String)String.format("Http Listener with path %s contains an invalid use of a wildcard. Wildcards can only be used at the end of the path (i.e.: /path/*) or between / characters (.i.e.: /path/*/anotherPath))", this.path)));
        }
    }

    private abstract class BaseResponseStatusCallback
    implements ResponseStatusCallback {
        private final SourceCompletionCallback completionCallback;

        public BaseResponseStatusCallback(SourceCompletionCallback completionCallback) {
            this.completionCallback = completionCallback;
        }

        public void responseSendSuccessfully() {
            if (this.completionCallback != null) {
                this.completionCallback.success();
            }
        }

        public void onErrorSendingResponse(Throwable throwable) {
            if (this.completionCallback != null) {
                this.completionCallback.error(throwable);
            }
        }
    }
}

