/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.http.internal.listener;

import java.net.URI;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.extension.http.api.HttpRequestAttributesBuilder;
import org.mule.extension.http.internal.listener.ListenerPath;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.request.ClientConnection;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.utils.HttpEncoderDecoderUtils;

public class HttpRequestAttributesResolver {
    private static final String QUERY = "?";
    private HttpRequestContext requestContext;
    private ListenerPath listenerPath;

    public HttpRequestAttributesResolver setRequestContext(HttpRequestContext requestContext) {
        this.requestContext = requestContext;
        return this;
    }

    public HttpRequestAttributesResolver setListenerPath(ListenerPath listenerPath) {
        this.listenerPath = listenerPath;
        return this;
    }

    public HttpRequestAttributes resolve() {
        String listenerPath = this.listenerPath.getResolvedPath();
        HttpRequest request = this.requestContext.getRequest();
        URI uri = request.getUri();
        String path = uri.getPath();
        String rawPath = uri.getRawPath();
        String uriString = path;
        String rawUriString = rawPath;
        String relativePath = this.listenerPath.getRelativePath(path);
        ClientConnection clientConnection = this.requestContext.getClientConnection();
        String queryString = uri.getQuery();
        String rawQuery = uri.getRawQuery();
        if (queryString != null) {
            uriString = uriString + QUERY + queryString;
            rawUriString = rawUriString + QUERY + rawQuery;
        } else {
            queryString = "";
        }
        return new HttpRequestAttributesBuilder().listenerPath(listenerPath).relativePath(relativePath).requestPath(path).rawRequestPath(rawPath).requestUri(uriString).rawRequestUri(rawUriString).method(request.getMethod()).scheme(this.requestContext.getScheme()).version(request.getProtocol().asString()).headers((MultiMap<String, String>)request.getHeaders()).uriParams(HttpEncoderDecoderUtils.decodeUriParams((String)listenerPath, (String)rawPath)).queryString(queryString).queryParams((MultiMap<String, String>)HttpEncoderDecoderUtils.decodeQueryString((String)rawQuery)).localAddress(this.requestContext.getServerConnection().getLocalHostAddress().toString()).remoteAddress(clientConnection.getRemoteHostAddress().toString()).clientCertificate(() -> ((ClientConnection)clientConnection).getClientCertificate()).build();
    }
}

